/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.search.spans.ConjunctionSpans;
import org.apache.lucene.search.spans.Spans;

abstract class ContainSpans
extends ConjunctionSpans {
    Spans sourceSpans;
    Spans bigSpans;
    Spans littleSpans;

    ContainSpans(Spans bigSpans, Spans littleSpans, Spans sourceSpans) {
        super(Arrays.asList(bigSpans, littleSpans));
        this.bigSpans = Objects.requireNonNull(bigSpans);
        this.littleSpans = Objects.requireNonNull(littleSpans);
        this.sourceSpans = Objects.requireNonNull(sourceSpans);
    }

    @Override
    public int startPosition() {
        return this.atFirstInCurrentDoc ? -1 : (this.oneExhaustedInCurrentDoc ? Integer.MAX_VALUE : this.sourceSpans.startPosition());
    }

    @Override
    public int endPosition() {
        return this.atFirstInCurrentDoc ? -1 : (this.oneExhaustedInCurrentDoc ? Integer.MAX_VALUE : this.sourceSpans.endPosition());
    }

    @Override
    public boolean isPayloadAvailable() throws IOException {
        return this.sourceSpans.isPayloadAvailable();
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        return this.sourceSpans.getPayload();
    }
}

