define([
    'jquery',
    'msg/Msg',
    'unifi/service/location/locationService',
    'unifi/util/QueryString',
    //non-exporting
    'foundation',
    'retina'
], function (
    $,
    Msg,
    locationService,
    QueryString
) {
    'use strict';
    $(function () {
        $(document).foundation();

        var $loginForm = $('#LoginForm'),
            $recoverForm = $('#RecoverForm'),
            $resetCancelButton = $('#ResetCancelButton'),
            $errorMessage = $('.error-message'),
            $recoverMessage = $('.recover-message'),
            $modalError = $('#Modal > .modal-background'),
            queryString = QueryString.getQueryStringObject(),
            redirectUrl = queryString && queryString.redirect && decodeURIComponent(queryString.redirect)
        ;

        $loginForm.find('#LoginDescription > h1').text(Msg.G_PleaseLogin);
        $loginForm.find('#LoginDescription > .error-message').text(Msg.E_InvalidLogin);
        $loginForm.find('#LoginDescription > .recover-message').text(Msg.G_RecoverMessage);
        $loginForm.find('#LoginUsername').attr('placeholder', Msg.G_UN);
        $loginForm.find('#LoginPassword').attr('placeholder', Msg.G_PW);
        $loginForm.find('#LoginButton').text(Msg.G_Login).attr('value', Msg.G_Login);
        $loginForm.find('#ForgotPassword').text(Msg.G_ForgotPassword);

        $recoverForm.find('.form-container > p').text(Msg.G_EnterEmailAddress);
        $recoverForm.find('.form-container > label.email small').text(Msg.G_Invalid);
        $recoverForm.find('.form-container > div.controls #ResetCancelButton').text(Msg.G_Back);
        $recoverForm.find('.form-container > div.controls #ResetPasswordButton').text(Msg.G_ResetPassword);

        $modalError.find('h1').text(Msg.E_WontWork);
        $modalError.find('p').text(Msg.E_WontWorkDetail);

        $loginForm.on('submit', function() {
            $.ajax({
                url: '/api/login',
                type: 'POST',
                data: JSON.stringify({
                    username: $('#LoginUsername').val(),
                    password: $('#LoginPassword').val(),
                    strict: true
                }),
                success: function(data, textStatus, xhr) {
                    $errorMessage.hide();

                    if(textStatus && textStatus === 'success' && xhr && xhr.status === 200) {
                        $.get('/api/self', {}, function(data) {
                            if (redirectUrl && (
                                redirectUrl.indexOf('/manage') === 0 ||
                                redirectUrl.indexOf('/hotspot') === 0 ||
                                redirectUrl.indexOf('/unifi') === 0
                            )) {
                                window.location.href = redirectUrl;
                            }
                            else {
                                locationService.gotoManagePage(data.last_site_name);
                            }
                        });
                    }
                },
                error: function(xhr, textStatus, errorThrown) {
                    $errorMessage.show();
                }
            });

            return false;
        });

        $recoverForm.on('submit', function() {
            $.ajax({
                url: '/api/recover',
                type: 'POST',
                data: JSON.stringify({
                    email: $('#ResetPasswordEmailInput').val()
                }),
                complete: function(data, textStatus, xhr) {
                    $resetCancelButton.click();
                    $errorMessage.hide();
                    $recoverMessage.fadeIn().delay(3000).fadeOut();
                }
            });

            return false;
        });


        $('#ForgotPassword').on('click', function() {
            $loginForm.hide();
            $recoverForm.show();
            return false;
        });

        $resetCancelButton.on('click', function() {
            $recoverForm.hide();
            $loginForm.show();
            return false;
        });

        // retina
        $('.retina').retinise();
    });
});
