/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import org.GNOME.Accessibility.JavaBridge;

public class ApplicationAccessible
implements Accessible {
    AccessibleContext accContext = new AccessibleAppContext();

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accContext;
    }

    public class AccessibleAppContext
    extends AccessibleContext {
        List vtoplevels = Collections.synchronizedList(new LinkedList());
        final WindowListener l = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:activate");
            }

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "object:state-changed");
            }

            public void windowDeiconifed(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:restore");
            }

            public void windowIconifieded(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:minimize");
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:deactivate");
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                if (AccessibleAppContext.this.isToplevel(window)) {
                    AccessibleAppContext.this.vtoplevels.remove(window);
                }
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:destroy");
                JavaBridge.dispatchEvent(ApplicationAccessible.this.getAccessibleContext(), "object:children-changed:remove", 0, 0);
                if (AccessibleAppContext.this.toplevelCount() == 0) {
                    JavaBridge.exit();
                }
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                if (AccessibleAppContext.this.isToplevel(window)) {
                    if (!AccessibleAppContext.this.vtoplevels.contains(window)) {
                        AccessibleAppContext.this.vtoplevels.add(window);
                        Window window2 = window;
                        window2.getAccessibleContext().setAccessibleParent(ApplicationAccessible.this);
                    }
                } else {
                    System.out.println("WARNING: Unhandled Window type : " + window.toString());
                }
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:create");
                if (windowEvent.getSource() instanceof Accessible) {
                    JavaBridge.traverseMenus(((Accessible)windowEvent.getSource()).getAccessibleContext());
                }
                JavaBridge.dispatchEvent(ApplicationAccessible.this.getAccessibleContext(), "object:children-changed:add", 0, 0);
            }
        };
        AWTEventListener globalListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof WindowEvent) {
                    switch (aWTEvent.getID()) {
                        case 200: {
                            ((WindowEvent)aWTEvent).getWindow().addWindowListener(AccessibleAppContext.this.l);
                            break;
                        }
                        case 208: {
                            JavaBridge.dispatchFocusEvent(null);
                            break;
                        }
                    }
                } else if (aWTEvent instanceof FocusEvent) {
                    switch (aWTEvent.getID()) {
                        case 1004: {
                            JavaBridge.dispatchFocusEvent(aWTEvent.getSource());
                            break;
                        }
                    }
                }
            }
        };
        Toolkit toolkit = Toolkit.getDefaultToolkit();

        private int toplevelCount() {
            return this.vtoplevels.size();
        }

        private boolean isToplevel(Object object) {
            return object instanceof Window || object instanceof Frame || object instanceof Dialog;
        }

        public AccessibleAppContext() {
            this.toolkit.addAWTEventListener(this.globalListener, 68L);
            this.toolkit.getSystemEventQueue().push(JavaBridge.getEventQueue());
            for (int i = 0; i < this.getAccessibleChildrenCount(); ++i) {
                Accessible accessible = this.getAccessibleChild(i);
            }
        }

        @Override
        public Locale getLocale() {
            return null;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            Accessible accessible = null;
            if (n < this.toplevelCount()) {
                accessible = (Accessible)this.vtoplevels.get(n);
                accessible.getAccessibleContext().setAccessibleParent(ApplicationAccessible.this);
            }
            return accessible;
        }

        @Override
        public Accessible getAccessibleParent() {
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.toplevelCount();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.UNKNOWN;
        }

        @Override
        public String getAccessibleName() {
            String string = null;
            if (this.toplevelCount() > 0) {
                for (int i = 0; i < this.getAccessibleChildrenCount(); ++i) {
                    String string2;
                    Accessible accessible = this.getAccessibleChild(i);
                    if (accessible == null || (string2 = accessible.getAccessibleContext().getAccessibleName()) == null || string2.length() == 0) continue;
                    string = string2;
                    break;
                }
            }
            if (string == null) {
                string = "Java Application";
            }
            return string;
        }

        @Override
        public String getAccessibleDescription() {
            return "an accessible Java app";
        }
    }
}

