/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.fonts.CIDSet;
import org.apache.fop.fonts.MultiByteFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIDFull
implements CIDSet {
    private BitSet glyphIndices;
    private final MultiByteFont font;

    public CIDFull(MultiByteFont mbf) {
        this.font = mbf;
    }

    private void initGlyphIndices() {
        if (this.glyphIndices == null) {
            this.glyphIndices = this.font.getGlyphIndices();
        }
    }

    @Override
    public int getOriginalGlyphIndex(int index) {
        return index;
    }

    @Override
    public char getUnicode(int index) {
        this.initGlyphIndices();
        if (this.glyphIndices.get(index)) {
            return (char)index;
        }
        return '\uffff';
    }

    @Override
    public int mapChar(int glyphIndex, char unicode) {
        return (char)glyphIndex;
    }

    @Override
    public Map<Integer, Integer> getGlyphs() {
        this.initGlyphIndices();
        HashMap<Integer, Integer> glyphs = new HashMap<Integer, Integer>();
        int nextBitSet = 0;
        for (int j = 0; j < this.glyphIndices.cardinality(); ++j) {
            nextBitSet = this.glyphIndices.nextSetBit(nextBitSet);
            glyphs.put(nextBitSet, nextBitSet);
            ++nextBitSet;
        }
        return Collections.unmodifiableMap(glyphs);
    }

    @Override
    public char[] getChars() {
        return this.font.getChars();
    }

    @Override
    public int getNumberOfGlyphs() {
        this.initGlyphIndices();
        return this.glyphIndices.length();
    }

    @Override
    public BitSet getGlyphIndices() {
        this.initGlyphIndices();
        return this.glyphIndices;
    }

    @Override
    public int[] getWidths() {
        return this.font.getWidths();
    }
}

