/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.ObjectAccessNode;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnresolvedObjectAccessNode;
import com.oracle.truffle.api.nodes.Node;

final class ForeignObjectAccessHeadNode
extends Node {
    @Node.Child
    private ObjectAccessNode first;
    private final Message accessTree;

    protected ForeignObjectAccessHeadNode(Message tree) {
        this.accessTree = tree;
        this.first = new UnresolvedObjectAccessNode();
        this.adoptChildren();
    }

    protected Message getAccessTree() {
        return this.accessTree;
    }

    protected ObjectAccessNode getFirst() {
        return this.first;
    }

    public Object executeForeign(VirtualFrame frame, TruffleObject receiver, Object ... arguments) {
        Object ret = this.first.executeWith(frame, receiver, arguments);
        assert (ForeignObjectAccessHeadNode.assertReturnValue(ret)) : "Only primitive values or TruffleObject expected: " + ret;
        return ret;
    }

    private static boolean assertReturnValue(Object ret) {
        if (ret instanceof Number) {
            return true;
        }
        if (ret instanceof String) {
            return true;
        }
        if (ret instanceof Character) {
            return true;
        }
        if (ret instanceof Boolean) {
            return true;
        }
        return ret instanceof TruffleObject;
    }
}

