/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccessArguments;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.ObjectAccessNode;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;

final class GenericObjectAccessNode
extends ObjectAccessNode {
    private final Message access;
    @Node.Child
    private IndirectCallNode indirectCallNode;
    @Node.Child
    private ForeignAccessArguments accessArguments = new ForeignAccessArguments();

    public GenericObjectAccessNode(Message access) {
        this.access = access;
        this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
    }

    public GenericObjectAccessNode(GenericObjectAccessNode prev) {
        this(prev.access);
    }

    @Override
    public Object executeWith(VirtualFrame frame, TruffleObject truffleObject, Object[] arguments) {
        CallTarget ct = this.findCallTarget(truffleObject);
        return this.indirectCallNode.call(frame, ct, this.accessArguments.executeCreate(truffleObject, arguments));
    }

    @CompilerDirectives.TruffleBoundary
    protected CallTarget findCallTarget(TruffleObject truffleObject) {
        ForeignAccess fa = truffleObject.getForeignAccess();
        CallTarget ct = fa.access(this.access);
        if (ct == null) {
            throw this.messageNotRecognizedException(fa);
        }
        return ct;
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException messageNotRecognizedException(ForeignAccess fa) {
        throw new IllegalStateException("Message " + this.access + " not recognized by " + fa);
    }
}

