/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.prefs;

import java.util.prefs.Preferences;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.windows.options.WinSysPanel;
import org.openide.util.NbPreferences;

public class SettingsImpl {
    private final Preferences prefs = NbPreferences.forModule(SettingsImpl.class).node("multi-tabs");
    static final String PROP_SHOW_FOLDER_NAME = "show-folder-name";
    static final String PROP_SHOW_FULL_PATH = "show-full-path";
    static final String PROP_SAME_PROJECT_SAME_COLOR = "same-project-same-color";
    static final String PROP_SORT_DOCUMENT_LIST_BY_PROJECT = "sort-document-list-by-project";
    static final String PROP_ROW_COUNT = "row-count";
    static final String PROP_TAB_ROW_PER_PROJECT = "tab-row-per-project";

    private Preferences getWinSysPrefs() {
        return NbPreferences.forModule(WinSysPanel.class);
    }

    public int getTabsLocation() {
        return this.getWinSysPrefs().getInt("document.tabs.placement", 1);
    }

    boolean setTabsLocation(int n) {
        boolean bl = n != this.getTabsLocation();
        this.getWinSysPrefs().putInt("document.tabs.placement", n);
        return bl;
    }

    public boolean isEnabled() {
        boolean bl = false;
        ProjectSupport projectSupport = ProjectSupport.getDefault();
        bl |= this.isShowFolderName();
        bl |= this.isSameProjectSameColor() && projectSupport.isEnabled();
        bl |= this.isShowFullPath();
        bl |= this.isSortDocumentListByProject() && projectSupport.isEnabled();
        bl |= this.getRowCount() > 1;
        bl |= this.isTabRowPerProject() && projectSupport.isEnabled();
        return bl |= this.getTabsLocation() != 1;
    }

    public boolean isShowFolderName() {
        return this.prefs.getBoolean(PROP_SHOW_FOLDER_NAME, false);
    }

    boolean setShowFolderName(boolean bl) {
        boolean bl2 = bl != this.isShowFolderName();
        this.prefs.putBoolean(PROP_SHOW_FOLDER_NAME, bl);
        return bl2;
    }

    public boolean isShowFullPath() {
        return this.prefs.getBoolean(PROP_SHOW_FULL_PATH, false);
    }

    boolean setShowFullPath(boolean bl) {
        boolean bl2 = bl != this.isShowFullPath();
        this.prefs.putBoolean(PROP_SHOW_FULL_PATH, bl);
        return bl2;
    }

    public boolean isSameProjectSameColor() {
        return this.prefs.getBoolean(PROP_SAME_PROJECT_SAME_COLOR, false);
    }

    boolean setSameProjectSameColor(boolean bl) {
        boolean bl2 = bl != this.isSameProjectSameColor();
        this.prefs.putBoolean(PROP_SAME_PROJECT_SAME_COLOR, bl);
        return bl2;
    }

    boolean setSortDocumentListByProject(boolean bl) {
        boolean bl2 = bl != this.isSortDocumentListByProject();
        this.prefs.putBoolean(PROP_SORT_DOCUMENT_LIST_BY_PROJECT, bl);
        return bl2;
    }

    public boolean isSortDocumentListByProject() {
        return this.prefs.getBoolean(PROP_SORT_DOCUMENT_LIST_BY_PROJECT, false);
    }

    public boolean isTabRowPerProject() {
        return this.prefs.getBoolean(PROP_TAB_ROW_PER_PROJECT, false);
    }

    boolean setTabRowPerProject(boolean bl) {
        boolean bl2 = bl != this.isTabRowPerProject();
        this.prefs.putBoolean(PROP_TAB_ROW_PER_PROJECT, bl);
        return bl2;
    }

    boolean setRowCount(int n) {
        boolean bl = n != this.getRowCount();
        this.prefs.putInt(PROP_ROW_COUNT, n);
        this.getWinSysPrefs().putBoolean("document.tabs.multirow", n > 1);
        return bl;
    }

    public int getRowCount() {
        int n = 1;
        if (this.getWinSysPrefs().getBoolean("document.tabs.multirow", false)) {
            n = 3;
        }
        return this.prefs.getInt(PROP_ROW_COUNT, n);
    }
}

