/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo.ice;

import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.UtilityException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Candidate
implements Comparable {
    private DatagramSocket socket;
    private CandidateType type;
    private short componentId;
    private int priority;
    private int foundationId;
    private Candidate base;
    private boolean isInUse;

    public Candidate(Address address, short componentId) throws SocketException, UnknownHostException, UtilityException {
        this.socket = new DatagramSocket(0, address.getInetAddress());
        this.type = CandidateType.Local;
        this.componentId = componentId;
        this.priority = 0;
        this.base = this;
        this.isInUse = false;
    }

    public Candidate(Address address, CandidateType type, short componentId, Candidate base) throws SocketException, UnknownHostException, UtilityException {
        this.socket = new DatagramSocket(0, address.getInetAddress());
        this.type = type;
        this.setComponentId(componentId);
        this.priority = 0;
        this.base = base;
        this.isInUse = false;
    }

    public void setBase(Candidate base) {
        this.base = base;
    }

    public Candidate getBase() {
        return this.base;
    }

    public CandidateType getCandidateType() {
        return this.type;
    }

    public void setComponentId(short componentId) {
        if (componentId < 1 || componentId > 256) {
            throw new IllegalArgumentException(String.valueOf(componentId) + " is not between 1 and 256 inclusive.");
        }
        this.componentId = componentId;
    }

    public short getComponentId() {
        return this.componentId;
    }

    public void setFoundationId(int foundationId) {
        this.foundationId = foundationId;
    }

    public int getFoundationId() {
        return this.foundationId;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public Address getAddress() throws UtilityException {
        return new Address(this.socket.getLocalAddress().getAddress());
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public void setInUse(boolean isInUse) {
        this.isInUse = isInUse;
    }

    public boolean getInUse() {
        return this.isInUse;
    }

    public int compareTo(Object arg0) {
        Candidate cand = (Candidate)arg0;
        return cand.getPriority() - this.getPriority();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return ((Candidate)o).socket.equals(this.socket) && ((Candidate)o).base.equals(this.base);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CandidateType {
        Local,
        ServerReflexive,
        PeerReflexive,
        Relayed;

    }
}

