/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHMethodDeclaration;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.TargetError;
import bsh.Types;
import bsh.UtilEvalError;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BshMethod
implements Serializable {
    NameSpace declaringNameSpace;
    Modifiers modifiers;
    private String name;
    private Class creturnType;
    private String[] paramNames;
    private int numArgs;
    private Class[] cparamTypes;
    BSHBlock methodBody;
    private Method javaMethod;
    private Object javaObject;

    BshMethod(BSHMethodDeclaration bSHMethodDeclaration, NameSpace nameSpace, Modifiers modifiers) {
        this(bSHMethodDeclaration.name, bSHMethodDeclaration.returnType, bSHMethodDeclaration.paramsNode.getParamNames(), bSHMethodDeclaration.paramsNode.paramTypes, bSHMethodDeclaration.blockNode, nameSpace, modifiers);
    }

    BshMethod(String string, Class clazz, String[] stringArray, Class[] classArray, BSHBlock bSHBlock, NameSpace nameSpace, Modifiers modifiers) {
        this.name = string;
        this.creturnType = clazz;
        this.paramNames = stringArray;
        if (stringArray != null) {
            this.numArgs = stringArray.length;
        }
        this.cparamTypes = classArray;
        this.methodBody = bSHBlock;
        this.declaringNameSpace = nameSpace;
        this.modifiers = modifiers;
    }

    BshMethod(Method method, Object object) {
        this(method.getName(), method.getReturnType(), null, method.getParameterTypes(), null, null, null);
        this.javaMethod = method;
        this.javaObject = object;
    }

    public Class[] getParameterTypes() {
        return this.cparamTypes;
    }

    public String[] getParameterNames() {
        return this.paramNames;
    }

    public Class getReturnType() {
        return this.creturnType;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Object invoke(Object[] objectArray, Interpreter interpreter) throws EvalError {
        return this.invoke(objectArray, interpreter, null, null, false);
    }

    public Object invoke(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        return this.invoke(objectArray, interpreter, callStack, simpleNode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invoke(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode, boolean bl) throws EvalError {
        if (this.javaMethod != null) {
            try {
                return Reflect.invokeOnMethod(this.javaMethod, this.javaObject, objectArray);
            }
            catch (ReflectError reflectError) {
                throw new EvalError("Error invoking Java method: " + reflectError, simpleNode, callStack);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TargetError("Exception invoking imported object method.", invocationTargetException, simpleNode, callStack, true);
            }
        }
        if (this.modifiers != null && this.modifiers.hasModifier("synchronized")) {
            Object object;
            if (this.declaringNameSpace.isClass) {
                try {
                    object = this.declaringNameSpace.getClassInstance();
                }
                catch (UtilEvalError utilEvalError) {
                    throw new InterpreterError("Can't get class instance for synchronized method.");
                }
            } else {
                object = this.declaringNameSpace.getThis(interpreter);
            }
            Object object2 = object;
            synchronized (object2) {
                return this.invokeImpl(objectArray, interpreter, callStack, simpleNode, bl);
            }
        }
        return this.invokeImpl(objectArray, interpreter, callStack, simpleNode, bl);
    }

    private Object invokeImpl(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode, boolean bl) throws EvalError {
        NameSpace nameSpace;
        Class clazz = this.getReturnType();
        Class[] classArray = this.getParameterTypes();
        if (callStack == null) {
            callStack = new CallStack(this.declaringNameSpace);
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (objectArray.length != this.numArgs) {
            throw new EvalError("Wrong number of arguments for local method: " + this.name, simpleNode, callStack);
        }
        if (bl) {
            nameSpace = callStack.top();
        } else {
            nameSpace = new NameSpace(this.declaringNameSpace, this.name);
            nameSpace.isMethod = true;
        }
        nameSpace.setNode(simpleNode);
        for (int i = 0; i < this.numArgs; ++i) {
            if (classArray[i] != null) {
                try {
                    objectArray[i] = Types.getAssignableForm(objectArray[i], classArray[i]);
                }
                catch (UtilEvalError utilEvalError) {
                    throw new EvalError("Invalid argument: `" + this.paramNames[i] + "'" + " for method: " + this.name + " : " + utilEvalError.getMessage(), simpleNode, callStack);
                }
                try {
                    nameSpace.setTypedVariable(this.paramNames[i], classArray[i], objectArray[i], null);
                    continue;
                }
                catch (UtilEvalError utilEvalError) {
                    throw utilEvalError.toEvalError("Typed method parameter assignment", simpleNode, callStack);
                }
            }
            if (objectArray[i] == Primitive.VOID) {
                throw new EvalError("Undefined variable or class name, parameter: " + this.paramNames[i] + " to method: " + this.name, simpleNode, callStack);
            }
            try {
                nameSpace.setLocalVariable(this.paramNames[i], objectArray[i], interpreter.getStrictJava());
                continue;
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError(simpleNode, callStack);
            }
        }
        if (!bl) {
            callStack.push(nameSpace);
        }
        Object object = this.methodBody.eval(callStack, interpreter, true);
        CallStack callStack2 = callStack.copy();
        if (!bl) {
            callStack.pop();
        }
        ReturnControl returnControl = null;
        if (object instanceof ReturnControl) {
            returnControl = (ReturnControl)object;
            if (returnControl.kind != 46) {
                throw new EvalError("'continue' or 'break' in method body", returnControl.returnPoint, callStack2);
            }
            object = ((ReturnControl)object).value;
            if (clazz == Void.TYPE && object != Primitive.VOID) {
                throw new EvalError("Cannot return value from void method", returnControl.returnPoint, callStack2);
            }
        }
        if (clazz != null) {
            if (clazz == Void.TYPE) {
                return Primitive.VOID;
            }
            try {
                object = Types.getAssignableForm(object, clazz);
            }
            catch (UtilEvalError utilEvalError) {
                SimpleNode simpleNode2 = simpleNode;
                if (returnControl != null) {
                    simpleNode2 = returnControl.returnPoint;
                }
                throw utilEvalError.toEvalError("Incorrect type returned from method: " + this.name + utilEvalError.getMessage(), simpleNode2, callStack);
            }
        }
        return object;
    }

    public boolean hasModifier(String string) {
        return this.modifiers != null && this.modifiers.hasModifier(string);
    }

    public String toString() {
        return "Scripted Method: " + StringUtil.methodString(this.name, this.getParameterTypes());
    }
}

