/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoMembershipShape;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.Vector;

public class GeoCompositeMembershipShape
implements GeoMembershipShape {
    protected final List<GeoMembershipShape> shapes = new ArrayList<GeoMembershipShape>();

    public void addShape(GeoMembershipShape shape) {
        this.shapes.add(shape);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.isWithin(point.x, point.y, point.z);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (GeoMembershipShape shape : this.shapes) {
            if (!shape.isWithin(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.shapes.get(0).getEdgePoints();
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        for (GeoMembershipShape shape : this.shapes) {
            if (!shape.intersects(p, notablePoints, bounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        for (GeoMembershipShape shape : this.shapes) {
            shape.getBounds(bounds);
        }
    }

    @Override
    public double computeOutsideDistance(DistanceStyle distanceStyle, GeoPoint point) {
        return this.computeOutsideDistance(distanceStyle, point.x, point.y, point.z);
    }

    @Override
    public double computeOutsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.isWithin(x, y, z)) {
            return 0.0;
        }
        double distance = Double.MAX_VALUE;
        for (GeoMembershipShape shape : this.shapes) {
            double normalDistance = shape.computeOutsideDistance(distanceStyle, x, y, z);
            if (!(normalDistance < distance)) continue;
            distance = normalDistance;
        }
        return distance;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GeoCompositeMembershipShape)) {
            return false;
        }
        GeoCompositeMembershipShape other = (GeoCompositeMembershipShape)o;
        return super.equals(o) && this.shapes.equals(other.shapes);
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.shapes.hashCode();
    }

    public String toString() {
        return "GeoCompositeMembershipShape: {" + this.shapes + '}';
    }
}

