/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.coffeescript.CoffeeScriptSourceSet;
import org.gradle.language.coffeescript.internal.DefaultCoffeeScriptSourceSet;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.internal.JavaScriptSourceCode;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.tasks.PlayCoffeeScriptCompile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayCoffeeScriptPlugin
implements Plugin<Project> {
    private static final String DEFAULT_COFFEESCRIPT_VERSION = "1.8.0";
    private static final String DEFAULT_RHINO_VERSION = "1.7R4";

    static String getDefaultCoffeeScriptDependencyNotation() {
        return String.format("org.coffeescript:coffee-script-js:%s@js", DEFAULT_COFFEESCRIPT_VERSION);
    }

    static String getDefaultRhinoDependencyNotation() {
        return String.format("org.mozilla:rhino:%s", DEFAULT_RHINO_VERSION);
    }

    public void apply(Project target) {
        target.getPluginManager().apply(ComponentModelBasePlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CoffeeScript
    implements LanguageTransform<CoffeeScriptSourceSet, JavaScriptSourceCode> {
        private CoffeeScript() {
        }

        public Class<CoffeeScriptSourceSet> getSourceSetType() {
            return CoffeeScriptSourceSet.class;
        }

        public Class<JavaScriptSourceCode> getOutputType() {
            return JavaScriptSourceCode.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new SourceTransformTaskConfig(){

                public String getTaskPrefix() {
                    return "compile";
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return PlayCoffeeScriptCompile.class;
                }

                public void configureTask(Task task, BinarySpec binarySpec, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
                    PlayApplicationBinarySpecInternal binary = (PlayApplicationBinarySpecInternal)binarySpec;
                    CoffeeScriptSourceSet coffeeScriptSourceSet = (CoffeeScriptSourceSet)sourceSet;
                    PlayCoffeeScriptCompile coffeeScriptCompile = (PlayCoffeeScriptCompile)task;
                    JavaScriptSourceSet javaScriptSourceSet = binary.getGeneratedJavaScript().get(coffeeScriptSourceSet);
                    coffeeScriptCompile.setDescription("Compiles coffeescript for the " + coffeeScriptSourceSet.getDisplayName() + ".");
                    File generatedSourceDir = binary.getNamingScheme().getOutputDirectory(task.getProject().getBuildDir(), "src");
                    File outputDirectory = new File(generatedSourceDir, javaScriptSourceSet.getName());
                    coffeeScriptCompile.setDestinationDir(outputDirectory);
                    coffeeScriptCompile.setSource(coffeeScriptSourceSet.getSource());
                    javaScriptSourceSet.getSource().srcDir((Object)outputDirectory);
                    javaScriptSourceSet.builtBy(new Object[]{coffeeScriptCompile});
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof PlayApplicationBinarySpecInternal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @LanguageType
        void registerCoffeeScript(LanguageTypeBuilder<CoffeeScriptSourceSet> builder) {
            builder.setLanguageName("coffeeScript");
            builder.defaultImplementation(DefaultCoffeeScriptSourceSet.class);
        }

        @Mutate
        void createCoffeeScriptSourceSets(ModelMap<PlayApplicationSpec> components) {
            components.afterEach((Action)new Action<PlayApplicationSpec>(){

                public void execute(PlayApplicationSpec playComponent) {
                    playComponent.getSources().create("coffeeScript", CoffeeScriptSourceSet.class, (Action)new Action<CoffeeScriptSourceSet>(){

                        public void execute(CoffeeScriptSourceSet coffeeScriptSourceSet) {
                            coffeeScriptSourceSet.getSource().srcDir((Object)"app/assets");
                            coffeeScriptSourceSet.getSource().include(new String[]{"**/*.coffee"});
                        }
                    });
                }
            });
        }

        @Mutate
        void createGeneratedJavaScriptSourceSets(ModelMap<PlayApplicationBinarySpecInternal> binaries, ServiceRegistry serviceRegistry) {
            final FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            binaries.all((Action)new Action<PlayApplicationBinarySpecInternal>(){

                public void execute(PlayApplicationBinarySpecInternal playApplicationBinarySpec) {
                    for (CoffeeScriptSourceSet coffeeScriptSourceSet : playApplicationBinarySpec.getInputs().withType(CoffeeScriptSourceSet.class)) {
                        playApplicationBinarySpec.addGeneratedJavaScript(coffeeScriptSourceSet, fileResolver);
                    }
                }
            });
        }

        @BinaryTasks
        void configureCoffeeScriptCompileDefaults(ModelMap<Task> tasks, PlayApplicationBinarySpecInternal binary) {
            tasks.beforeEach(PlayCoffeeScriptCompile.class, (Action)new Action<PlayCoffeeScriptCompile>(){

                public void execute(PlayCoffeeScriptCompile coffeeScriptCompile) {
                    coffeeScriptCompile.setRhinoClasspathNotation(PlayCoffeeScriptPlugin.getDefaultRhinoDependencyNotation());
                    coffeeScriptCompile.setCoffeeScriptJsNotation(PlayCoffeeScriptPlugin.getDefaultCoffeeScriptDependencyNotation());
                }
            });
        }

        @Mutate
        void registerLanguageTransform(LanguageTransformContainer languages) {
            languages.add((Object)new CoffeeScript());
        }
    }
}

