/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cunit.plugins;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.c.CSourceSet;
import org.gradle.language.c.plugins.CLangPlugin;
import org.gradle.model.Finalize;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.test.cunit.CUnitTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.cunit.CUnitTestSuiteSpec;
import org.gradle.nativeplatform.test.cunit.internal.DefaultCUnitTestSuiteBinary;
import org.gradle.nativeplatform.test.cunit.internal.DefaultCUnitTestSuiteSpec;
import org.gradle.nativeplatform.test.cunit.tasks.GenerateCUnitLauncher;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinariesRules;
import org.gradle.nativeplatform.test.internal.NativeTestSuites;
import org.gradle.nativeplatform.test.plugins.NativeBinariesTestPlugin;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.test.TestSuiteContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class CUnitPlugin
implements Plugin<Project> {
    private final ModelRegistry modelRegistry;

    @Inject
    public CUnitPlugin(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(NativeBinariesTestPlugin.class);
        project.getPluginManager().apply(CLangPlugin.class);
        NativeTestSuiteBinariesRules.apply(this.modelRegistry, CUnitTestSuiteBinarySpec.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        private static final String CUNIT_LAUNCHER_SOURCE_SET = "cunitLauncher";

        Rules() {
        }

        @ComponentType
        public void registerCUnitTestSuiteSpecType(ComponentTypeBuilder<CUnitTestSuiteSpec> builder) {
            builder.defaultImplementation(DefaultCUnitTestSuiteSpec.class);
        }

        @Finalize
        public void configureCUnitTestSuiteSources(TestSuiteContainer testSuites, final @Path(value="buildDir") File buildDir) {
            for (final CUnitTestSuiteSpec suite : testSuites.withType(CUnitTestSuiteSpec.class).values()) {
                suite.getSources().create(CUNIT_LAUNCHER_SOURCE_SET, CSourceSet.class, (Action)new Action<CSourceSet>(){

                    public void execute(CSourceSet launcherSources) {
                        File baseDir = new File(buildDir, String.format("src/%s/cunitLauncher", suite.getName()));
                        launcherSources.getSource().srcDir((Object)new File(baseDir, "c"));
                        launcherSources.getExportedHeaders().srcDir((Object)new File(baseDir, "headers"));
                    }
                });
                suite.getSources().withType(CSourceSet.class).named("c", (Action)new Action<CSourceSet>(){

                    public void execute(CSourceSet cSourceSet) {
                        cSourceSet.lib(suite.getSources().get(Rules.CUNIT_LAUNCHER_SOURCE_SET));
                    }
                });
            }
        }

        @Mutate
        public void createCUnitLauncherTasks(TaskContainer tasks, TestSuiteContainer testSuites) {
            for (CUnitTestSuiteSpec suite : testSuites.withType(CUnitTestSuiteSpec.class).values()) {
                String taskName = suite.getName() + "CUnitLauncher";
                GenerateCUnitLauncher skeletonTask = (GenerateCUnitLauncher)tasks.create(taskName, GenerateCUnitLauncher.class);
                CSourceSet launcherSources = this.findLauncherSources(suite);
                skeletonTask.setSourceDir((File)launcherSources.getSource().getSrcDirs().iterator().next());
                skeletonTask.setHeaderDir((File)launcherSources.getExportedHeaders().getSrcDirs().iterator().next());
                launcherSources.builtBy(new Object[]{skeletonTask});
            }
        }

        private CSourceSet findLauncherSources(CUnitTestSuiteSpec suite) {
            return (CSourceSet)suite.getSources().withType(CSourceSet.class).get(CUNIT_LAUNCHER_SOURCE_SET);
        }

        @BinaryType
        public void registerCUnitTestBinaryType(BinaryTypeBuilder<CUnitTestSuiteBinarySpec> builder) {
            builder.defaultImplementation(DefaultCUnitTestSuiteBinary.class);
        }

        @ComponentBinaries
        public void createCUnitTestBinaries(ModelMap<CUnitTestSuiteBinarySpec> binaries, CUnitTestSuiteSpec testSuite, @Path(value="buildDir") File buildDir, ServiceRegistry serviceRegistry, ITaskFactory taskFactory) {
            NativeTestSuites.createNativeTestSuiteBinaries(binaries, testSuite, CUnitTestSuiteBinarySpec.class, "CUnitExe", buildDir, serviceRegistry);
        }
    }
}

