/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.Model;
import org.gradle.model.internal.core.Hidden;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenModelRuleExtractor;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelCreationRuleExtractor
extends AbstractAnnotationDrivenModelRuleExtractor<Model> {
    private ModelPath determineModelName(MethodRuleDefinition<?, ?> ruleDefinition, RuleSourceValidationProblemCollector problems) {
        String annotationValue = ruleDefinition.getAnnotation(Model.class).value();
        String modelName = annotationValue == null || annotationValue.isEmpty() ? ruleDefinition.getMethodName() : annotationValue;
        try {
            ModelPath.validatePath(modelName);
        }
        catch (Exception e) {
            problems.add(ruleDefinition, "The declared model element path '" + modelName + "' is not a valid path", e);
        }
        return ModelPath.path(modelName);
    }

    @Override
    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        ModelPath modelPath = this.determineModelName(ruleDefinition, context);
        this.validateMethod(ruleDefinition, context);
        if (context.hasProblems()) {
            return null;
        }
        return this.buildRule(modelPath, ruleDefinition);
    }

    protected <R, S> void validateMethod(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
    }

    protected abstract <R, S> ExtractedModelRule buildRule(ModelPath var1, MethodRuleDefinition<R, S> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ExtractedCreationRule<R, S>
    implements ExtractedModelRule {
        protected final ModelPath modelPath;
        protected final MethodRuleDefinition<R, S> ruleDefinition;
        private final boolean hidden;

        public ExtractedCreationRule(ModelPath modelPath, MethodRuleDefinition<R, S> ruleDefinition) {
            this.modelPath = modelPath;
            this.ruleDefinition = ruleDefinition;
            this.hidden = ruleDefinition.isAnnotationPresent(Hidden.class);
        }

        protected abstract void buildRegistration(MethodModelRuleApplicationContext var1, ModelRegistrations.Builder var2);

        @Override
        public void apply(MethodModelRuleApplicationContext context, MutableModelNode target) {
            if (!target.getPath().equals(ModelPath.ROOT)) {
                throw new InvalidModelRuleDeclarationException(String.format("Rule %s cannot be applied at the scope of model element %s as creation rules cannot be used when applying rule sources to particular elements", this.ruleDefinition.getDescriptor(), target.getPath()));
            }
            ModelRegistrations.Builder registration = ModelRegistrations.of(this.modelPath).descriptor(this.ruleDefinition.getDescriptor());
            this.buildRegistration(context, registration);
            registration.hidden(this.hidden);
            context.getRegistry().register(registration.build());
        }

        public List<Class<?>> getRuleDependencies() {
            return Collections.emptyList();
        }
    }
}

