/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.model.Path;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.MethodModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultMethodRuleDefinition<T, R, S>
implements MethodRuleDefinition<R, S> {
    private ImmutableList<ModelReference<?>> references;
    private final WeaklyTypeReferencingMethod<T, R> method;

    private DefaultMethodRuleDefinition(Method method, ModelType<T> instanceType, ModelType<R> returnType) {
        this.method = WeaklyTypeReferencingMethod.of(instanceType, returnType, method);
        ImmutableList.Builder referencesBuilder = ImmutableList.builder();
        for (int i = 0; i < method.getGenericParameterTypes().length; ++i) {
            Annotation[] paramAnnotations = method.getParameterAnnotations()[i];
            referencesBuilder.add(this.reference(paramAnnotations, i));
        }
        this.references = referencesBuilder.build();
    }

    public static <T> MethodRuleDefinition<?, ?> create(Class<T> source, Method method) {
        return DefaultMethodRuleDefinition.innerCreate(source, method);
    }

    private static <T, R, S> MethodRuleDefinition<R, S> innerCreate(Class<T> source, Method method) {
        ModelType returnType = ModelType.returnType(method);
        return new DefaultMethodRuleDefinition(method, ModelType.of(source), returnType);
    }

    @Override
    public WeaklyTypeReferencingMethod<?, R> getMethod() {
        return this.method;
    }

    @Override
    public String getMethodName() {
        return this.method.getName();
    }

    @Override
    public ModelType<R> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    @Nullable
    public ModelReference<S> getSubjectReference() {
        return (ModelReference)Cast.uncheckedCast(this.references.isEmpty() ? null : (ModelReference)this.references.get(0));
    }

    @Override
    public List<ModelReference<?>> getTailReferences() {
        return this.references.size() > 1 ? this.references.subList(1, this.references.size()) : Collections.emptyList();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.method.getMethod().getAnnotation(annotationType);
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return new MethodModelRuleDescriptor(this.method);
    }

    @Override
    public List<ModelReference<?>> getReferences() {
        return this.references;
    }

    private ModelReference<?> reference(Annotation[] annotations, int i) {
        Path pathAnnotation = (Path)CollectionUtils.findFirst((Object[])annotations, (Spec)new Spec<Annotation>(){

            public boolean isSatisfiedBy(Annotation element) {
                return element.annotationType().equals(Path.class);
            }
        });
        ModelPath path = pathAnnotation == null ? null : ModelPath.path(pathAnnotation.value());
        ModelType<?> cast = this.method.getGenericParameterTypes().get(i);
        return ModelReference.of(path, cast, String.format("parameter %s", i + 1));
    }
}

