// Generated by IcedCoffeeScript 1.7.1-f
(function() {
  var FileBundle, SoftwareUpgrade, constants, createHash, fs, iced, log, make_esc, npm, path, __iced_k, __iced_k_noop;

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  make_esc = require('iced-error').make_esc;

  npm = require('./npm').npm;

  path = require('path');

  fs = require('fs');

  log = require('./log');

  constants = require('./constants').constants;

  createHash = require('crypto').createHash;

  FileBundle = (function() {
    function FileBundle(uri, body) {
      this.uri = uri;
      this.body = body;
    }

    FileBundle.prototype.filename = function() {
      return path.basename(this.uri.path);
    };

    FileBundle.prototype.fullpath = function() {
      return this._fullpath;
    };

    FileBundle.prototype.version = function() {
      var parts;
      parts = this.filename().split(/-/);
      parts = parts[1].split(/\./).slice(0, -1);
      return parts.join(".");
    };

    FileBundle.prototype.hash = function() {
      return createHash('SHA512').update(this.body).digest('hex');
    };

    FileBundle.prototype.write = function(dir, encoding, cb) {
      var err, mode, p, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      p = this._fullpath = path.join(dir, this.filename());
      mode = process.platform === 'win32' ? 0x180 : 0x100;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
            funcname: "FileBundle.write"
          });
          fs.writeFile(p, _this.body, {
            mode: mode,
            encoding: encoding
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 33
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    return FileBundle;

  })();

  exports.SoftwareUpgrade = SoftwareUpgrade = (function() {
    function SoftwareUpgrade(config) {
      this.config = config;
    }

    SoftwareUpgrade.prototype.fetch = function(file, cb) {
      var body, err, req, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
            funcname: "SoftwareUpgrade.fetch"
          });
          _this.config.request(file, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                req = arguments[1];
                return body = arguments[2];
              };
            })(),
            lineno: 47
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            ret = new FileBundle(req.request.uri, body);
          }
          return cb(err, ret);
        };
      })(this));
    };

    SoftwareUpgrade.prototype.fetch_package = function(cb) {
      var err, file, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      file = ["pkg", ((_ref = this.config.argv.get()) != null ? _ref[0] : void 0) || constants.links.stable].join('/');
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
            funcname: "SoftwareUpgrade.fetch_package"
          });
          _this.fetch(file, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1["package"] = arguments[1];
              };
            })(_this),
            lineno: 55
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    SoftwareUpgrade.prototype.fetch_signature = function(cb) {
      var err, file, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      file = "/sig/files/" + (this.config.key_version()) + "/" + (this["package"].filename()) + ".asc";
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
            funcname: "SoftwareUpgrade.fetch_signature"
          });
          _this.fetch(file, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.signature = arguments[1];
              };
            })(_this),
            lineno: 62
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    SoftwareUpgrade.prototype.write_files = function(cb) {
      var esc, tmpdir, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "SoftwareUpgrade::write_files");
      log.debug("+ SoftwareUpgrade::write_files");
      tmpdir = this.config.get_tmpdir();
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
            funcname: "SoftwareUpgrade.write_files"
          });
          _this["package"].write(tmpdir, 'binary', esc(__iced_deferrals.defer({
            lineno: 71
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
              funcname: "SoftwareUpgrade.write_files"
            });
            _this.signature.write(tmpdir, 'utf8', esc(__iced_deferrals.defer({
              lineno: 72
            })));
            __iced_deferrals._fulfill();
          })(function() {
            log.debug("- SoftwareUpgrade::write_files");
            return cb(null);
          });
        };
      })(this));
    };

    SoftwareUpgrade.prototype.verify_signature = function(cb) {
      var args, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ SoftwareUpgrade::verify_signature");
      args = {
        which: 'code',
        sig: this.signature.fullpath(),
        file: this["package"].fullpath()
      };
      log.debug("| Verify signature w/ " + (JSON.stringify(args)));
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
            funcname: "SoftwareUpgrade.verify_signature"
          });
          _this.config.oneshot_verify(args, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 85
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log.info("verified signature of " + (_this["package"].filename()) + " against " + (_this.signature.filename()));
          log.debug("- SoftwareUpgrade::verify_signature");
          return cb(err);
        };
      })(this));
    };

    SoftwareUpgrade.prototype.verify_hash = function(cb) {
      var err, h1, h2, v;
      h1 = this["package"].hash();
      h2 = this.config.index_lookup_hash((v = this["package"].version()));
      log.debug("| Verify hash on version " + v + ": " + h1 + " v " + h2);
      err = null;
      if (h1 !== h2) {
        err = new Error("Hash mismatch on " + (this["package"].filename()) + ": " + h1 + " != " + h2);
      }
      return cb(err);
    };

    SoftwareUpgrade.prototype.install_package = function(cb) {
      var args, err, p, x, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ SoftwareUpgrade::install_package");
      p = this["package"].fullpath();
      log.debug("| Full name for install: " + p);
      log.info("Running npm install " + (this["package"].filename()) + ": this may take a minute, please be patient");
      if ((x = this.config.install_prefix()) != null) {
        log.warn("(Using non-standard install prefix: " + x + ")");
      }
      args = ["install", "-g", p];
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
            funcname: "SoftwareUpgrade.install_package"
          });
          npm({
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 110
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- SoftwareUpgrade::install_package");
          return cb(err);
        };
      })(this));
    };

    SoftwareUpgrade.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "SoftwareUpgrade::run");
      log.debug("+ SoftwareUpgrade::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
            funcname: "SoftwareUpgrade.run"
          });
          _this.fetch_package(esc(__iced_deferrals.defer({
            lineno: 119
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
              funcname: "SoftwareUpgrade.run"
            });
            _this.fetch_signature(esc(__iced_deferrals.defer({
              lineno: 120
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
                funcname: "SoftwareUpgrade.run"
              });
              _this.write_files(esc(__iced_deferrals.defer({
                lineno: 121
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
                  funcname: "SoftwareUpgrade.run"
                });
                _this.verify_hash(esc(__iced_deferrals.defer({
                  lineno: 122
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
                    funcname: "SoftwareUpgrade.run"
                  });
                  _this.verify_signature(esc(__iced_deferrals.defer({
                    lineno: 123
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-installer/src/software_upgrade.iced",
                      funcname: "SoftwareUpgrade.run"
                    });
                    _this.install_package(esc(__iced_deferrals.defer({
                      lineno: 124
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    log.debug("- SoftwareUpgrade::run");
                    return cb(null);
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    return SoftwareUpgrade;

  })();

}).call(this);
