// Generated by IcedCoffeeScript 1.8.0-e
(function() {
  var BaseScraper, CoinbaseScraper, constants, iced, v_codes, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  BaseScraper = require('./base').BaseScraper;

  constants = require('../constants').constants;

  v_codes = constants.v_codes;

  exports.CoinbaseScraper = CoinbaseScraper = (function(_super) {
    __extends(CoinbaseScraper, _super);

    function CoinbaseScraper() {
      return CoinbaseScraper.__super__.constructor.apply(this, arguments);
    }

    CoinbaseScraper.prototype._check_args = function(args) {
      if (!(args.username != null)) {
        return new Error("Bad args to Coinbase proof: no username given");
      } else if (!(args.name != null) || (args.name !== 'coinbase')) {
        return new Error("Bad args to Coinbase proof: type is " + args.name);
      } else {
        return null;
      }
    };

    CoinbaseScraper.prototype.profile_url = function(username) {
      return "https://coinbase.com/" + username + "/public-key";
    };

    CoinbaseScraper.prototype.get_tor_error = function(args) {
      return [new Error("Can't (yet) check Coinbase over Tor due to CloudFlare"), v_codes.TOR_INCOMPATIBLE];
    };

    CoinbaseScraper.prototype.hunt2 = function(_arg, cb) {
      var err, name, out, proof_text_check, rc, url, username;
      username = _arg.username, proof_text_check = _arg.proof_text_check, name = _arg.name;
      rc = v_codes.OK;
      out = {};
      if ((err = this._check_args({
        username: username,
        name: name
      })) == null) {
        url = this.profile_url(username);
        out = {
          rc: rc,
          api_url: url,
          human_url: url,
          remote_id: username
        };
      }
      return cb(err, out);
    };

    CoinbaseScraper.prototype._check_api_url = function(_arg) {
      var api_url, username;
      api_url = _arg.api_url, username = _arg.username;
      return api_url === this.profile_url(username);
    };

    CoinbaseScraper.prototype.check_status = function(_arg, cb) {
      var $, api_url, divs, err, html, proof_text_check, rc, remote_id, txt, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, api_url = _arg.api_url, proof_text_check = _arg.proof_text_check, remote_id = _arg.remote_id;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/scrapers/coinbase.iced",
            funcname: "CoinbaseScraper.check_status"
          });
          _this._get_url_body({
            url: api_url
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                rc = arguments[1];
                return html = arguments[2];
              };
            })(),
            lineno: 55
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _ref;
          if (rc === v_codes.OK) {
            $ = _this.libs.cheerio.load(html);
            divs = $('pre.statement');
            rc = !divs.length ? v_codes.FAILED_PARSE : (txt = (_ref = divs.first()) != null ? _ref.html() : void 0) == null ? v_codes.CONTENT_MISSING : (txt = txt.replace(/\r/g, ''), txt.indexOf(proof_text_check) >= 0 ? v_codes.OK : v_codes.NOT_FOUND);
          }
          return cb(err, rc);
        };
      })(this));
    };

    return CoinbaseScraper;

  })(BaseScraper);

}).call(this);
