/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import org.sejda.model.exception.TaskPermissionsException;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.encryption.AccessPermission;

public class PDDocumentAccessPermission {
    private AccessPermission permissions;

    PDDocumentAccessPermission(PDDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("Unable to get permissions from null instance.");
        }
        this.permissions = document.getCurrentAccessPermission();
    }

    public void ensureOwnerPermissions() throws TaskPermissionsException {
        if (!Boolean.getBoolean("sejda.unethical.read") && !this.permissions.isOwnerPermission()) {
            throw new TaskPermissionsException("Owner permission is required.");
        }
    }

    public void ensurePermission(PdfAccessPermission required) throws TaskPermissionsException {
        if (!Boolean.getBoolean("sejda.unethical.read") && !ForwardingPdfAccessPermission.valueFromPdfAccessPermission(required).isAllowed(this.permissions)) {
            throw new TaskPermissionsException(String.format("Permission %s is not granted.", required));
        }
    }

    private static enum ForwardingPdfAccessPermission {
        MODIFY(PdfAccessPermission.MODIFY){

            @Override
            boolean isAllowed(AccessPermission permissions) {
                return permissions.canModify();
            }
        }
        ,
        ASSEMBLE(PdfAccessPermission.ASSEMBLE){

            @Override
            boolean isAllowed(AccessPermission permissions) {
                return permissions.canAssembleDocument();
            }
        }
        ,
        COPY_AND_EXTRACT(PdfAccessPermission.COPY_AND_EXTRACT){

            @Override
            boolean isAllowed(AccessPermission permissions) {
                return permissions.canExtractContent();
            }
        }
        ,
        DEGRADATED_PRINT(PdfAccessPermission.DEGRADATED_PRINT){

            @Override
            boolean isAllowed(AccessPermission permissions) {
                return permissions.canPrintDegraded();
            }
        }
        ,
        EXTRACTION_FOR_DISABLES(PdfAccessPermission.EXTRACTION_FOR_DISABLES){

            @Override
            boolean isAllowed(AccessPermission permissions) {
                return permissions.canExtractForAccessibility();
            }
        }
        ,
        FILL_FORMS(PdfAccessPermission.FILL_FORMS){

            @Override
            boolean isAllowed(AccessPermission permissions) {
                return permissions.canFillInForm();
            }
        }
        ,
        PRINT(PdfAccessPermission.PRINT){

            @Override
            boolean isAllowed(AccessPermission permissions) {
                return permissions.canPrint();
            }
        }
        ,
        ANNOTATION(PdfAccessPermission.ANNOTATION){

            @Override
            boolean isAllowed(AccessPermission permissions) {
                return permissions.canModifyAnnotations();
            }
        };

        private PdfAccessPermission permission;

        private ForwardingPdfAccessPermission(PdfAccessPermission permission) {
            this.permission = permission;
        }

        abstract boolean isAllowed(AccessPermission var1);

        static ForwardingPdfAccessPermission valueFromPdfAccessPermission(PdfAccessPermission accessPermission) {
            for (ForwardingPdfAccessPermission current : ForwardingPdfAccessPermission.values()) {
                if (current.permission != accessPermission) continue;
                return current;
            }
            throw new IllegalArgumentException(String.format("No Forwarding access permission found for %s", accessPermission));
        }
    }
}

