/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.WorkerEnv;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;

public class JkMain
implements MBeanRegistration {
    WorkerEnv wEnv;
    String propFile;
    Properties props = new Properties();
    Properties modules = new Properties();
    boolean modified = false;
    boolean started = false;
    boolean saveProperties = false;
    private static String DEFAULT_HTTPS = "com.sun.net.ssl.internal.www.protocol";
    String out;
    String err;
    File propsF;
    static String[] defaultHandlers = new String[]{"request", "container", "channelSocket"};
    long initTime;
    long startTime;
    static JkMain jkMain = null;
    static Hashtable replacements = new Hashtable();
    private static String CNAME;
    static Log log;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public JkMain() {
        jkMain = this;
        this.modules.put("channelSocket", "org.apache.jk.common.ChannelSocket");
        this.modules.put("channelNioSocket", "org.apache.jk.common.ChannelNioSocket");
        this.modules.put("channelUnix", "org.apache.jk.common.ChannelUn");
        this.modules.put("channelJni", "org.apache.jk.common.ChannelJni");
        this.modules.put("apr", "org.apache.jk.apr.AprImpl");
        this.modules.put("mx", "org.apache.jk.common.JkMX");
        this.modules.put("modeler", "org.apache.jk.common.JkModeler");
        this.modules.put("shm", "org.apache.jk.common.Shm");
        this.modules.put("request", "org.apache.jk.common.HandlerRequest");
        this.modules.put("container", "org.apache.jk.common.HandlerRequest");
        this.modules.put("modjk", "org.apache.jk.common.ModJkMX");
    }

    public static JkMain getJkMain() {
        return jkMain;
    }

    private void initHTTPSUrls() {
        try {
            String value = System.getProperty("java.protocol.handler.pkgs");
            if (value == null) {
                value = DEFAULT_HTTPS;
            } else {
                if (value.indexOf(DEFAULT_HTTPS) >= 0) {
                    return;
                }
                value = value + "|" + DEFAULT_HTTPS;
            }
            System.setProperty("java.protocol.handler.pkgs", value);
        }
        catch (Exception ex) {
            log.info((Object)"Error adding SSL Protocol Handler", (Throwable)ex);
        }
    }

    public void setPropertiesFile(String p) {
        this.propFile = p;
        if (this.started) {
            this.loadPropertiesFile();
        }
    }

    public String getPropertiesFile() {
        return this.propFile;
    }

    public void setSaveProperties(boolean b) {
        this.saveProperties = b;
    }

    public void setProperty(String n, String v) {
        if ("jkHome".equals(n)) {
            this.setJkHome(v);
        }
        if ("propertiesFile".equals(n)) {
            this.setPropertiesFile(v);
        }
        this.props.put(n, v);
        if (this.started) {
            String alias = (String)replacements.get(n);
            if (alias != null) {
                this.props.put(alias, v);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Substituting " + n + " " + alias + " " + v));
                }
            }
            this.processProperty(n, v);
            if (alias != null) {
                this.processProperty(alias, v);
            }
            this.saveProperties();
        }
    }

    public Object getProperty(String name) {
        String alias = (String)replacements.get(name);
        Object result = null;
        if (alias != null) {
            result = this.props.get(alias);
        }
        if (result == null) {
            result = this.props.get(name);
        }
        return result;
    }

    public void setChannelClassName(String name) {
        this.props.put("handler.channel.className", name);
    }

    public String getChannelClassName() {
        return (String)this.props.get("handler.channel.className");
    }

    public void setWorkerClassName(String name) {
        this.props.put("handler.container.className", name);
    }

    public String getWorkerClassName() {
        return (String)this.props.get("handler.container.className");
    }

    public void setJkHome(String s) {
        this.getWorkerEnv().setJkHome(s);
    }

    public String getJkHome() {
        return this.getWorkerEnv().getJkHome();
    }

    public void setOut(String s) {
        this.out = s;
    }

    public String getOut() {
        return this.out;
    }

    public void setErr(String s) {
        this.err = s;
    }

    public String getErr() {
        return this.err;
    }

    public void init() throws IOException {
        String home;
        long t1 = System.currentTimeMillis();
        if (null != this.out) {
            PrintStream outS = new PrintStream(new FileOutputStream(this.out));
            System.setOut(outS);
        }
        if (null != this.err) {
            PrintStream errS = new PrintStream(new FileOutputStream(this.err));
            System.setErr(errS);
        }
        if ((home = this.getWorkerEnv().getJkHome()) == null) {
            this.guessHome();
        }
        if ((home = this.getWorkerEnv().getJkHome()) == null) {
            log.info((Object)"Can't find home, jk2.properties not loaded");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting Jk2, base dir= " + home));
        }
        this.loadPropertiesFile();
        String initHTTPS = (String)this.props.get("class.initHTTPS");
        if ("true".equalsIgnoreCase(initHTTPS)) {
            this.initHTTPSUrls();
        }
        long t2 = System.currentTimeMillis();
        this.initTime = t2 - t1;
    }

    public void stop() {
        MBeanServer s = Registry.getRegistry(null, null).getMBeanServer();
        for (int i = 0; i < this.wEnv.getHandlerCount(); ++i) {
            JkHandler handler = this.wEnv.getHandler(i);
            if (handler == null) continue;
            String handlerName = handler.getName();
            try {
                handler.destroy();
            }
            catch (IOException ex) {
                log.error((Object)("Error stopping " + handlerName), (Throwable)ex);
            }
            if (this.domain == null) continue;
            try {
                ObjectName handlerOname = new ObjectName(this.domain + ":" + "type=JkHandler,name=" + handlerName);
                if (!s.isRegistered(handlerOname)) continue;
                s.unregisterMBean(handlerOname);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Error unregistering " + handlerName), (Throwable)e);
            }
        }
        this.started = false;
        if (this.domain != null) {
            try {
                ObjectName wEnvName = new ObjectName(this.domain + ":type=JkWorkerEnv");
                if (s.isRegistered(wEnvName)) {
                    s.unregisterMBean(wEnvName);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error unregistering JkWorkerEnv", (Throwable)e);
            }
        }
        if (this.oname != null && s.isRegistered(this.oname)) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception e) {
                log.error((Object)("Error unregistering jkmain " + e));
            }
        }
    }

    public void start() throws IOException {
        int i;
        long t1 = System.currentTimeMillis();
        String[] handlers = defaultHandlers;
        String workers = this.props.getProperty("handler.list", null);
        if (workers != null) {
            handlers = this.split(workers, ",");
        }
        this.processModules();
        for (i = 0; i < handlers.length; ++i) {
            String name = handlers[i];
            JkHandler w = this.getWorkerEnv().getHandler(name);
            if (w != null) continue;
            this.newHandler(name, "", name);
        }
        this.processProperties();
        for (i = 0; i < this.wEnv.getHandlerCount(); ++i) {
            if (this.wEnv.getHandler(i) == null) continue;
            try {
                this.wEnv.getHandler(i).init();
                continue;
            }
            catch (IOException ex) {
                if ("apr".equals(this.wEnv.getHandler(i).getName())) {
                    log.info((Object)("APR not loaded, disabling jni components: " + ex.toString()));
                    continue;
                }
                log.error((Object)("error initializing " + this.wEnv.getHandler(i).getName()), (Throwable)ex);
            }
        }
        this.started = true;
        long t2 = System.currentTimeMillis();
        this.startTime = t2 - t1;
        this.saveProperties();
        log.info((Object)("Jk running ID=" + this.wEnv.getLocalId() + " time=" + this.initTime + "/" + this.startTime + "  config=" + this.propFile));
    }

    public WorkerEnv getWorkerEnv() {
        if (this.wEnv == null) {
            this.wEnv = new WorkerEnv();
        }
        return this.wEnv;
    }

    public void setWorkerEnv(WorkerEnv wEnv) {
        this.wEnv = wEnv;
    }

    public void setBeanProperty(Object target, String name, String val) {
        if (val != null) {
            val = IntrospectionUtils.replaceProperties(val, this.props, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setProperty " + target + " " + name + "=" + val));
        }
        IntrospectionUtils.setProperty(target, name, val);
    }

    public void setPropertyString(String handlerN, String name, String val) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setProperty " + handlerN + " " + name + "=" + val));
        }
        JkHandler target = this.getWorkerEnv().getHandler(handlerN);
        this.setBeanProperty(target, name, val);
        if (this.started) {
            this.saveProperties();
        }
    }

    public long getInitTime() {
        return this.initTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1 && ("-?".equals(args[0]) || "-h".equals(args[0]))) {
                System.out.println("Usage: ");
                System.out.println("  JkMain [args]");
                System.out.println();
                System.out.println("  Each bean setter corresponds to an arg ( like -debug 10 )");
                System.out.println("  System properties:");
                System.out.println("    jk2.home    Base dir of jk2");
                return;
            }
            jkMain = new JkMain();
            IntrospectionUtils.processArgs(jkMain, args, new String[0], null, new Hashtable());
            jkMain.init();
            jkMain.start();
        }
        catch (Exception ex) {
            log.warn((Object)"Error running", (Throwable)ex);
        }
    }

    private boolean checkPropertiesFile() {
        if (this.propFile == null) {
            return false;
        }
        this.propsF = new File(this.propFile);
        if (!this.propsF.isAbsolute()) {
            String home = this.getWorkerEnv().getJkHome();
            if (home == null) {
                return false;
            }
            this.propsF = new File(home, this.propFile);
        }
        return this.propsF.exists();
    }

    private void loadPropertiesFile() {
        if (!this.checkPropertiesFile()) {
            return;
        }
        try {
            this.props.load(new FileInputStream(this.propsF));
        }
        catch (IOException ex) {
            log.warn((Object)("Unable to load properties from " + this.propsF), (Throwable)ex);
        }
    }

    public void saveProperties() {
        if (!this.saveProperties) {
            return;
        }
        if (this.propsF == null) {
            log.warn((Object)"No properties file specified. Unable to save");
            return;
        }
        File outFile = new File(this.propsF.getParentFile(), this.propsF.getName() + ".save");
        log.debug((Object)("Saving properties " + outFile));
        try {
            this.props.store(new FileOutputStream(outFile), "AUTOMATICALLY GENERATED");
        }
        catch (IOException ex) {
            log.warn((Object)("Unable to save to " + outFile), (Throwable)ex);
        }
    }

    private void preProcessProperties() {
        String key;
        Enumeration<Object> keys = this.props.keys();
        Vector<String> v = new Vector<String>();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            Object newName = replacements.get(key);
            if (newName == null) continue;
            v.addElement(key);
        }
        keys = v.elements();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            String propValue = this.props.getProperty(key);
            String replacement = (String)replacements.get(key);
            this.props.put(replacement, propValue);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Substituting " + key + " " + replacement + " " + propValue));
        }
    }

    private void processProperties() {
        this.preProcessProperties();
        Enumeration<Object> keys = this.props.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String propValue = this.props.getProperty(name);
            this.processProperty(name, propValue);
        }
    }

    private void processProperty(String name, String propValue) {
        String type = name;
        String fullName = name;
        String localName = "";
        String propName = "";
        if (name.startsWith("key.")) {
            return;
        }
        int dot = name.indexOf(".");
        int lastDot = name.lastIndexOf(".");
        if (dot > 0) {
            type = name.substring(0, dot);
            if (dot != lastDot) {
                localName = name.substring(dot + 1, lastDot);
                fullName = type + "." + localName;
            } else {
                fullName = type;
            }
        } else {
            return;
        }
        propName = name.substring(lastDot + 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing " + type + ":" + localName + ":" + fullName + " " + propName));
        }
        if ("class".equals(type) || "handler".equals(type)) {
            return;
        }
        JkHandler comp = this.getWorkerEnv().getHandler(fullName);
        if (comp == null) {
            comp = this.newHandler(type, localName, fullName);
        }
        if (comp == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting " + propName + " on " + fullName + " " + comp));
        }
        this.setBeanProperty(comp, propName, propValue);
    }

    private JkHandler newHandler(String type, String localName, String fullName) {
        JkHandler handler2;
        String classN = this.modules.getProperty(type);
        if (classN == null) {
            log.error((Object)("No class name for " + fullName + " " + type));
            return null;
        }
        try {
            Class<?> channelclass = Class.forName(classN);
            handler2 = (JkHandler)channelclass.newInstance();
        }
        catch (Throwable ex) {
            Object handler2 = null;
            log.error((Object)("Can't create " + fullName), ex);
            return null;
        }
        if (this.domain != null) {
            try {
                ObjectName handlerOname = new ObjectName(this.domain + ":" + "type=JkHandler,name=" + fullName);
                Registry.getRegistry(null, null).registerComponent((Object)handler2, handlerOname, classN);
            }
            catch (Exception e) {
                log.error((Object)("Error registering " + fullName), (Throwable)e);
            }
        }
        this.wEnv.addHandler(fullName, handler2);
        return handler2;
    }

    private void processModules() {
        Enumeration<Object> keys = this.props.keys();
        int plen = 6;
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            if (!k.startsWith("class.")) continue;
            String name = k.substring(plen);
            String propValue = this.props.getProperty(k);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register " + name + " " + propValue));
            }
            this.modules.put(name, propValue);
        }
    }

    private String[] split(String s, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, delim);
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        String[] res = new String[v.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)v.elementAt(i);
        }
        return res;
    }

    private void guessHome() {
        String home = this.wEnv.getJkHome();
        if (home != null) {
            return;
        }
        home = IntrospectionUtils.guessInstall("jk2.home", "jk2.home", "tomcat-jk2.jar", CNAME);
        if (home != null) {
            log.info((Object)("Guessed home " + home));
            this.wEnv.setJkHome(home);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void pause() throws Exception {
        if (this.wEnv != null) {
            for (int i = 0; i < this.wEnv.getHandlerCount(); ++i) {
                if (this.wEnv.getHandler(i) == null) continue;
                this.wEnv.getHandler(i).pause();
            }
        }
    }

    public void resume() throws Exception {
        for (int i = 0; i < this.wEnv.getHandlerCount(); ++i) {
            if (this.wEnv.getHandler(i) == null) continue;
            this.wEnv.getHandler(i).resume();
        }
    }

    static {
        replacements.put("port", "channelSocket.port");
        replacements.put("maxPort", "channelSocket.maxPort");
        replacements.put("maxThreads", "channelSocket.maxThreads");
        replacements.put("minSpareThreads", "channelSocket.minSpareThreads");
        replacements.put("maxSpareThreads", "channelSocket.maxSpareThreads");
        replacements.put("backlog", "channelSocket.backlog");
        replacements.put("tcpNoDelay", "channelSocket.tcpNoDelay");
        replacements.put("soTimeout", "channelSocket.soTimeout");
        replacements.put("timeout", "channelSocket.timeout");
        replacements.put("address", "channelSocket.address");
        replacements.put("bufferSize", "channelSocket.bufferSize");
        replacements.put("tomcatAuthentication", "request.tomcatAuthentication");
        replacements.put("packetSize", "channelSocket.packetSize");
        replacements.put("maxHeaderCount", "request.maxHeaderCount");
        CNAME = "org/apache/jk/server/JkMain.class";
        log = LogFactory.getLog(JkMain.class);
    }
}

