#!/bin/sh
#############################################################################
##
##  gap.sh                      GAP                          Martin Schoenert
##
##  This is a shell script for the  UNIX  operating system  that starts  GAP.
##  This is the place  where  you  make  all  the  necessary  customizations.
##  Then copy this file to a  directory in your  search path,  e.g., '~/bin'.
##  If you later move GAP to another location you must only change this file.
##


#############################################################################
##
##  GAP_DIR . . . . . . . . . . . . . . . . . . . . directory where GAP lives
##
##  Set 'GAP_DIR' to the name of the directory where you have installed  GAP,
##  i.e., the directory with the subdirectories  'lib',  'grp',  'doc',  etc.
##  The default is '/build/gap/src/gap4r7', which is where you installed GAP.
##  You won't have to change this unless you move the installation.
##
if [ "x$GAP_DIR" = "x" ];  then
GAP_DIR="/build/gap/src/gap4r7"
fi


#############################################################################
##
##  GAP_MEM . . . . . . . . . . . . . . . . . . . amount of initial workspace
##
##  Set 'GAP_MEM' to the amount of memory GAP shall use as initial workspace.
##  The default depends on whether GAP is compiled with in 32-bit or 64-bit
##  mode. You have to uncomment and change the following if you want GAP
##  to use a larger initial workspace. If you are not going to run GAP
##  in parallel with other programs you may want to set this value close
##  to the amount of memory your computer has.
##
#if [ "x$GAP_MEM" = "x" ];  then
#GAP_MEM="-m 256m"
#fi


#############################################################################
##
##  GAP_PRG . . . . . . . . . . . . . . . . .  name of the executable program
##
##  Set 'GAP_PRG' to the  name of the executable  program of the  GAP kernel.
##  The default is  '<target>/XX-bit/gap'  where  <target>  is the target you
##  have selected during compilation and  XX  is 32 or 64 - set automatically
##  according to your  system  architecture,  unless specified by  you at the 
##  './configure' stage.
##
if [ "x$GAP_PRG" = "x" ];  then
GAP_PRG=armv5tel-unknown-linux-gnueabi-gcc-default32/gap
fi


#############################################################################
##
##  GAP . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . run GAP
##
##  You  probably should  not change  this line,  which  finally starts  GAP.
##
exec "$GAP_DIR/bin/$GAP_PRG" $GAP_MEM -l "$GAP_DIR" "$@"
