/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.type1.AFMCharMetrics;
import org.apache.fop.fonts.type1.AFMParser;
import org.apache.fop.fonts.type1.AdobeStandardEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CharMetricsHandler {
    private static final Log LOG = LogFactory.getLog(CharMetricsHandler.class);
    private static final String WHITE_SPACE = "\\s*";
    private static final String OPERATOR = "([A-Z0-9]{1,3})";
    private static final String OPERANDS = "(.*)";
    private static final Pattern METRICS_REGEX = Pattern.compile("\\s*([A-Z0-9]{1,3})\\s*(.*)\\s*");
    private static final Pattern SPLIT_REGEX = Pattern.compile("\\s*;\\s*");

    private CharMetricsHandler() {
    }

    abstract AFMCharMetrics parse(String var1, Stack<Object> var2, String var3) throws IOException;

    static CharMetricsHandler getHandler(Map<String, AFMParser.ValueHandler> valueParsers, String line) {
        if (line != null && line.contains("AdobeStandardEncoding")) {
            return new AdobeStandardCharMetricsHandler(valueParsers);
        }
        return new DefaultCharMetricsHandler(valueParsers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdobeStandardCharMetricsHandler
    extends CharMetricsHandler {
        private final DefaultCharMetricsHandler defaultHandler;

        private AdobeStandardCharMetricsHandler(Map<String, AFMParser.ValueHandler> valueParsers) {
            this.defaultHandler = new DefaultCharMetricsHandler(valueParsers);
        }

        @Override
        AFMCharMetrics parse(String line, Stack<Object> stack, String afmFileName) throws IOException {
            AFMCharMetrics chm = this.defaultHandler.parse(line, stack, afmFileName);
            NamedCharacter namedChar = chm.getCharacter();
            if (namedChar != null) {
                String charName = namedChar.getName();
                int codePoint = AdobeStandardEncoding.getAdobeCodePoint(charName);
                if (chm.getCharCode() != codePoint && !".notdef".equals(charName)) {
                    LOG.info((Object)(afmFileName + ": named character '" + charName + "'" + " has an incorrect code point: " + chm.getCharCode() + ". Changed to " + codePoint));
                    chm.setCharCode(codePoint);
                }
            }
            return chm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultCharMetricsHandler
    extends CharMetricsHandler {
        private final Map<String, AFMParser.ValueHandler> valueParsers;

        private DefaultCharMetricsHandler(Map<String, AFMParser.ValueHandler> valueParsers) {
            this.valueParsers = valueParsers;
        }

        @Override
        AFMCharMetrics parse(String line, Stack<Object> stack, String afmFileName) throws IOException {
            String[] metrics;
            AFMCharMetrics chm = new AFMCharMetrics();
            stack.push(chm);
            for (String metric : metrics = SPLIT_REGEX.split(line)) {
                Matcher matcher = METRICS_REGEX.matcher(metric);
                if (!matcher.matches()) continue;
                String operator = matcher.group(1);
                String operands = matcher.group(2);
                AFMParser.ValueHandler handler = this.valueParsers.get(operator);
                if (handler == null) continue;
                handler.parse(operands, 0, stack);
            }
            stack.pop();
            return chm;
        }
    }
}

