/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.GeneralPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class MultipolygonTest
extends Test {
    public static final int WRONG_MEMBER_TYPE = 1601;
    public static final int WRONG_MEMBER_ROLE = 1602;
    public static final int NON_CLOSED_WAY = 1603;
    public static final int MISSING_OUTER_WAY = 1604;
    public static final int INNER_WAY_OUTSIDE = 1605;
    public static final int CROSSING_WAYS = 1606;
    public static final int OUTER_STYLE_MISMATCH = 1607;
    public static final int INNER_STYLE_MISMATCH = 1608;
    public static final int NOT_CLOSED = 1609;
    public static final int NO_STYLE = 1610;
    public static final int NO_STYLE_POLYGON = 1611;
    public static final int OUTER_STYLE = 1613;
    private static volatile ElemStyles styles;
    private final Set<String> keysCheckedByAnotherTest = new HashSet<String>();

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon", new Object[0]), I18n.tr("This test checks if multipolygons are valid.", new Object[0]));
    }

    @Override
    public void initialize() {
        styles = MapPaintStyles.getStyles();
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.keysCheckedByAnotherTest.clear();
        for (Test test : OsmValidator.getEnabledTests(false)) {
            if (!(test instanceof UnclosedWays)) continue;
            this.keysCheckedByAnotherTest.addAll(((UnclosedWays)test).getCheckedKeys());
            break;
        }
    }

    @Override
    public void endTest() {
        this.keysCheckedByAnotherTest.clear();
        super.endTest();
    }

    private static GeneralPath createPath(List<Node> list) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)list.get(0).getCoor().lat(), (float)list.get(0).getCoor().lon());
        for (int i = 1; i < list.size(); ++i) {
            Node node = list.get(i);
            generalPath.lineTo((float)node.getCoor().lat(), (float)node.getCoor().lon());
        }
        return generalPath;
    }

    private List<GeneralPath> createPolygons(List<Multipolygon.PolyData> list) {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        for (Multipolygon.PolyData polyData : list) {
            arrayList.add(MultipolygonTest.createPath(polyData.getNodes()));
        }
        return arrayList;
    }

    private static Multipolygon.PolyData.Intersection getPolygonIntersection(GeneralPath generalPath, List<Node> list) {
        boolean bl = false;
        boolean bl2 = false;
        for (Node node : list) {
            boolean bl3 = generalPath.contains(node.getCoor().lat(), node.getCoor().lon());
            if (!((bl |= bl3) & (bl2 |= !bl3))) continue;
            return Multipolygon.PolyData.Intersection.CROSSING;
        }
        return bl ? Multipolygon.PolyData.Intersection.INSIDE : Multipolygon.PolyData.Intersection.OUTSIDE;
    }

    @Override
    public void visit(Way way) {
        if (!way.isArea() && ElemStyles.hasOnlyAreaElemStyle(way)) {
            List<Node> list = way.getNodes();
            if (list.isEmpty()) {
                return;
            }
            for (String string : this.keysCheckedByAnotherTest) {
                if (!way.hasKey(string)) continue;
                return;
            }
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Area style way is not closed", new Object[0]), 1609, Collections.singletonList(way), Arrays.asList(list.get(0), list.get(list.size() - 1))));
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isMultipolygon()) {
            this.checkMembersAndRoles(relation);
            this.checkOuterWay(relation);
            if (!relation.hasIncompleteMembers()) {
                Multipolygon multipolygon = MultipolygonCache.getInstance().get(Main.map.mapView, relation);
                this.checkMemberRoleCorrectness(relation);
                this.checkStyleConsistency(relation, multipolygon);
                this.checkGeometry(relation, multipolygon);
            }
        }
    }

    private void checkOuterWay(Relation relation) {
        boolean bl = false;
        for (RelationMember relationMember : relation.getMembers()) {
            if (!"outer".equals(relationMember.getRole())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.addError(relation, new TestError((Test)this, Severity.WARNING, I18n.tr("No outer way for multipolygon", new Object[0]), 1604, relation));
        }
    }

    private void checkMemberRoleCorrectness(Relation relation) {
        Pair<Relation, Relation> pair = CreateMultipolygonAction.createMultipolygonRelation(relation.getMemberPrimitives(Way.class), false);
        if (pair != null) {
            for (RelationMember relationMember : relation.getMembers()) {
                Collection<RelationMember> collection = ((Relation)pair.b).getMembersFor(Collections.singleton(relationMember.getMember()));
                if (collection == null || collection.isEmpty()) continue;
                String string = collection.iterator().next().getRole();
                if (relationMember.getRole().equals(string)) continue;
                ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
                arrayList.add(relation);
                arrayList.add(relationMember.getMember());
                this.addError(relation, new TestError(this, Severity.WARNING, RelationChecker.ROLE_VERIF_PROBLEM_MSG, I18n.tr("Role for ''{0}'' should be ''{1}''", relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance()), string), MessageFormat.format("Role for ''{0}'' should be ''{1}''", relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance()), string), 1602, arrayList, Collections.singleton(relationMember.getMember())));
            }
        }
    }

    private void checkStyleConsistency(Relation relation, Multipolygon multipolygon) {
        if (styles != null && !"boundary".equals(relation.get("type"))) {
            boolean bl;
            AreaElement areaElement = ElemStyles.getAreaElemStyle(relation, false);
            boolean bl2 = bl = areaElement != null;
            if (areaElement == null) {
                Way way;
                Iterator<Way> iterator = multipolygon.getOuterWays().iterator();
                while (iterator.hasNext() && (areaElement = ElemStyles.getAreaElemStyle(way = iterator.next(), true)) == null) {
                }
                if (areaElement == null) {
                    this.addError(relation, new TestError((Test)this, Severity.OTHER, I18n.tr("No area style for multipolygon", new Object[0]), 1610, relation));
                } else {
                    this.addError(relation, new TestError((Test)this, Severity.WARNING, I18n.trn("Multipolygon relation should be tagged with area tags and not the outer way", "Multipolygon relation should be tagged with area tags and not the outer ways", multipolygon.getOuterWays().size(), new Object[0]), 1611, relation));
                }
            }
            if (areaElement != null) {
                ArrayList<OsmPrimitive> arrayList;
                AreaElement areaElement2;
                for (Way way : multipolygon.getInnerWays()) {
                    areaElement2 = ElemStyles.getAreaElemStyle(way, false);
                    if (areaElement2 == null || !areaElement.equals(areaElement2)) continue;
                    arrayList = new ArrayList<OsmPrimitive>();
                    arrayList.add(relation);
                    arrayList.add(way);
                    this.addError(relation, new TestError(this, Severity.OTHER, I18n.tr("With the currently used mappaint style the style for inner way equals the multipolygon style", new Object[0]), 1608, arrayList, Collections.singletonList(way)));
                }
                for (Way way : multipolygon.getOuterWays()) {
                    areaElement2 = ElemStyles.getAreaElemStyle(way, false);
                    if (areaElement2 == null) continue;
                    arrayList = new ArrayList();
                    arrayList.add(relation);
                    arrayList.add(way);
                    if (!areaElement.equals(areaElement2)) {
                        this.addError(relation, new TestError(this, Severity.OTHER, !bl ? I18n.tr("Style for outer way mismatches", new Object[0]) : I18n.tr("With the currently used mappaint style(s) the style for outer way mismatches the area style", new Object[0]), 1607, arrayList, Collections.singletonList(way)));
                        continue;
                    }
                    if (!bl) continue;
                    this.addError(relation, new TestError(this, Severity.WARNING, I18n.tr("Area style on outer way", new Object[0]), 1613, arrayList, Collections.singletonList(way)));
                }
            }
        }
    }

    private void checkGeometry(Relation relation, Multipolygon multipolygon) {
        int n;
        Multipolygon.PolyData polyData;
        int n2;
        List<Multipolygon.PolyData> list;
        List<Node> list2 = multipolygon.getOpenEnds();
        if (!list2.isEmpty()) {
            list = new LinkedList<Multipolygon.PolyData>();
            list.add((Multipolygon.PolyData)((Object)relation));
            list.addAll(list2);
            this.addError(relation, new TestError(this, Severity.WARNING, I18n.tr("Multipolygon is not closed", new Object[0]), 1603, list, list2));
        }
        list = multipolygon.getInnerPolygons();
        List<Multipolygon.PolyData> list3 = multipolygon.getOuterPolygons();
        List<GeneralPath> list4 = list.isEmpty() ? Collections.emptyList() : this.createPolygons(list);
        List<GeneralPath> list5 = this.createPolygons(list3);
        for (n2 = 0; n2 < list3.size(); ++n2) {
            polyData = list3.get(n2);
            for (n = n2 + 1; n < list3.size(); ++n) {
                this.checkCrossingWays(relation, list3, list5, polyData, n);
            }
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            polyData = list.get(n2);
            for (n = n2 + 1; n < list.size(); ++n) {
                this.checkCrossingWays(relation, list, list4, polyData, n);
            }
            n = 1;
            for (int i = 0; i < list3.size(); ++i) {
                n &= this.checkCrossingWays(relation, list3, list5, polyData, i) == Multipolygon.PolyData.Intersection.OUTSIDE ? 1 : 0;
            }
            if (n == 0) continue;
            this.addError(relation, new TestError(this, Severity.WARNING, I18n.tr("Multipolygon inner way is outside", new Object[0]), 1605, Collections.singletonList(relation), Arrays.asList(polyData.getNodes())));
        }
    }

    private Multipolygon.PolyData.Intersection checkCrossingWays(Relation relation, List<Multipolygon.PolyData> list, List<GeneralPath> list2, Multipolygon.PolyData polyData, int n) {
        Multipolygon.PolyData polyData2;
        Multipolygon.PolyData.Intersection intersection = MultipolygonTest.getPolygonIntersection(list2.get(n), polyData.getNodes());
        if (intersection == Multipolygon.PolyData.Intersection.CROSSING && (polyData2 = list.get(n)) != null) {
            this.addError(relation, new TestError(this, Severity.WARNING, I18n.tr("Intersection between multipolygon ways", new Object[0]), 1606, Collections.singletonList(relation), Arrays.asList(polyData.getNodes(), polyData2.getNodes())));
        }
        return intersection;
    }

    private void checkMembersAndRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.isWay()) {
                if (relationMember.hasRole("inner", "outer") || !relationMember.hasRole()) continue;
                this.addError(relation, new TestError((Test)this, Severity.WARNING, I18n.tr("No useful role for multipolygon member", new Object[0]), 1602, relationMember.getMember()));
                continue;
            }
            if (relationMember.hasRole("admin_centre", "label", "subarea", "land_area")) continue;
            this.addError(relation, new TestError((Test)this, Severity.WARNING, I18n.tr("Non-Way in multipolygon", new Object[0]), 1601, relationMember.getMember()));
        }
    }

    private static void addRelationIfNeeded(TestError testError, Relation relation) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        if (!collection.contains(relation)) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.isIncomplete()) continue;
                return;
            }
            ArrayList<? extends OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection);
            arrayList.add(0, relation);
            testError.setPrimitives((List<? extends OsmPrimitive>)arrayList);
        }
    }

    private void addError(Relation relation, TestError testError) {
        MultipolygonTest.addRelationIfNeeded(testError, relation);
        this.errors.add(testError);
    }
}

