/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RelationMemberTransferable
implements Transferable {
    public static final DataFlavor RELATION_MEMBER_DATA = new DataFlavor(Data.class, Data.class.getName());
    private final Collection<RelationMember> members;

    public RelationMemberTransferable(Collection<RelationMember> collection) {
        this.members = collection;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{RELATION_MEMBER_DATA, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor == RELATION_MEMBER_DATA;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.getStringData();
        }
        if (RELATION_MEMBER_DATA.equals(dataFlavor)) {
            return this.getRelationMemberData();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected String getStringData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (RelationMember relationMember : this.members) {
            stringBuilder.append((Object)relationMember.getType());
            stringBuilder.append(" ").append(relationMember.getUniqueId());
            stringBuilder.append(" ").append(relationMember.getRole());
            stringBuilder.append(" # ").append(relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance()));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString().replace("\u200e", "").replace("\u200f", "");
    }

    protected Data getRelationMemberData() {
        ArrayList<RelationMemberData> arrayList = new ArrayList<RelationMemberData>(this.members.size());
        for (RelationMember relationMember : this.members) {
            arrayList.add(new RelationMemberData(relationMember.getRole(), relationMember.getType(), relationMember.getUniqueId()));
        }
        return new Data(arrayList);
    }

    public static final class Data
    implements Serializable {
        private static final long serialVersionUID = -8432393711635811029L;
        private final Collection<RelationMemberData> relationMemberDatas;

        private Data(Collection<RelationMemberData> collection) {
            CheckParameterUtil.ensureThat(collection instanceof Serializable, "primitiveData must be instanceof Serializable");
            this.relationMemberDatas = collection;
        }

        public Collection<RelationMemberData> getRelationMemberData() {
            return this.relationMemberDatas;
        }
    }
}

