/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.tools.Pair;

public class DividedScale<T> {
    private final List<Double> bd;
    private final List<T> data;

    protected DividedScale() {
        this.bd = new ArrayList<Double>();
        this.bd.add(0.0);
        this.bd.add(Double.POSITIVE_INFINITY);
        this.data = new ArrayList<T>();
        this.data.add(null);
    }

    protected DividedScale(DividedScale<T> dividedScale) {
        this.bd = new ArrayList<Double>(dividedScale.bd);
        this.data = new ArrayList<T>(dividedScale.data);
    }

    public T get(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("scale must be <= 0 but is " + d);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.bd.get(i) < d) || !(d <= this.bd.get(i + 1))) continue;
            return this.data.get(i);
        }
        throw new AssertionError();
    }

    public Pair<T, Range> getWithRange(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("scale must be <= 0 but is " + d);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.bd.get(i) < d) || !(d <= this.bd.get(i + 1))) continue;
            return new Pair<T, Range>(this.data.get(i), new Range(this.bd.get(i), this.bd.get(i + 1)));
        }
        throw new AssertionError();
    }

    public DividedScale<T> put(T t, Range range) {
        DividedScale<T> dividedScale = new DividedScale<T>(this);
        dividedScale.putImpl(t, range.getLower(), range.getUpper());
        dividedScale.consistencyTest();
        return dividedScale;
    }

    protected void putImpl(T t, double d, double d2) {
        int n = 0;
        while (this.bd.get(n) < d) {
            ++n;
        }
        if (this.bd.get(n) == d) {
            if (d2 > this.bd.get(n + 1)) {
                throw new RangeViolatedError("the new range must be within a single subrange (1)");
            }
            if (this.data.get(n) != null) {
                throw new RangeViolatedError("the new range must be within a subrange that has no data");
            }
            if (this.bd.get(n + 1) == d2) {
                this.data.set(n, t);
            } else {
                this.bd.add(n + 1, d2);
                this.data.add(n, t);
            }
        } else {
            if (this.bd.get(n) < d2) {
                throw new RangeViolatedError("the new range must be within a single subrange (2)");
            }
            if (this.data.get(n - 1) != null) {
                throw new AssertionError();
            }
            this.bd.add(n, d);
            this.data.add(n, t);
            if (this.bd.get(n + 1) > d2) {
                this.bd.add(n + 1, d2);
                this.data.add(n + 1, null);
            }
        }
    }

    public void consistencyTest() {
        if (this.bd.size() < 2) {
            throw new AssertionError(this.bd);
        }
        if (this.data.isEmpty()) {
            throw new AssertionError(this.data);
        }
        if (this.bd.size() != this.data.size() + 1) {
            throw new AssertionError();
        }
        if (this.bd.get(0) != 0.0) {
            throw new AssertionError();
        }
        if (this.bd.get(this.bd.size() - 1) != Double.POSITIVE_INFINITY) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.data.size() - 1; ++i) {
            if (this.bd.get(i) >= this.bd.get(i + 1)) {
                throw new AssertionError();
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DividedScale dividedScale = (DividedScale)object;
        return Objects.equals(this.bd, dividedScale.bd) && Objects.equals(this.data, dividedScale.data);
    }

    public int hashCode() {
        return Objects.hash(this.bd, this.data);
    }

    public String toString() {
        return "DS{" + this.bd + ' ' + this.data + '}';
    }

    public static class RangeViolatedError
    extends Error {
        public RangeViolatedError() {
        }

        public RangeViolatedError(String string) {
            super(string);
        }
    }
}

