/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class MapPaintStyles {
    private static ElemStyles styles = new ElemStyles();
    private static final CopyOnWriteArrayList<MapPaintSylesUpdateListener> listeners = new CopyOnWriteArrayList();

    public static ElemStyles getStyles() {
        return styles;
    }

    private MapPaintStyles() {
    }

    public static ImageProvider getIconProvider(IconReference iconReference, boolean bl) {
        String string = iconReference.source.getPrefName();
        ImageProvider imageProvider = new ImageProvider(iconReference.iconName).setDirs(MapPaintStyles.getIconSourceDirs(iconReference.source)).setId("mappaint." + string).setArchive(iconReference.source.zipIcons).setInArchiveDir(iconReference.source.getZipEntryDirName()).setOptional(true);
        if (bl && imageProvider.get() == null) {
            String string2 = "Mappaint style \"" + string + "\" (" + iconReference.source.getDisplayString() + ") icon \"" + iconReference.iconName + "\" not found.";
            iconReference.source.logWarning(string2);
            Main.warn(string2);
            return null;
        }
        return imageProvider;
    }

    public static ImageIcon getIcon(IconReference iconReference, int n, int n2) {
        String string = iconReference.source.getPrefName();
        ImageIcon imageIcon = MapPaintStyles.getIconProvider(iconReference, false).setWidth(n).setHeight(n2).get();
        if (imageIcon == null) {
            Main.warn("Mappaint style \"" + string + "\" (" + iconReference.source.getDisplayString() + ") icon \"" + iconReference.iconName + "\" not found.");
            return null;
        }
        return imageIcon;
    }

    public static ImageIcon getNoIcon_Icon(StyleSource styleSource) {
        return new ImageProvider("misc/no_icon").setDirs(MapPaintStyles.getIconSourceDirs(styleSource)).setId("mappaint." + styleSource.getPrefName()).setArchive(styleSource.zipIcons).setInArchiveDir(styleSource.getZipEntryDirName()).setOptional(true).get();
    }

    public static ImageIcon getNodeIcon(Tag tag) {
        return MapPaintStyles.getNodeIcon(tag, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getNodeIcon(Tag tag, boolean bl) {
        if (tag != null) {
            StyleElementList styleElementList;
            DataSet dataSet = new DataSet();
            Node node = new Node(LatLon.ZERO);
            node.put(tag.getKey(), tag.getValue());
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
            try {
                dataSet.addPrimitive(node);
                styleElementList = (StyleElementList)MapPaintStyles.getStyles().generateStyles((OsmPrimitive)node, (double)0.5, (boolean)false).a;
                dataSet.removePrimitive(node);
            }
            finally {
                MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
            }
            if (styleElementList != null) {
                for (StyleElement styleElement : styleElementList) {
                    MapImage mapImage;
                    if (!(styleElement instanceof NodeElement) || (mapImage = ((NodeElement)styleElement).mapImage) == null) continue;
                    if (bl || mapImage.name == null || !"misc/deprecated.png".equals(mapImage.name)) {
                        return new ImageIcon(mapImage.getImage(false));
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static List<String> getIconSourceDirs(StyleSource styleSource) {
        LinkedList<String> linkedList = new LinkedList<String>();
        File file = styleSource.getLocalSourceDir();
        if (file != null) {
            linkedList.add(file.getPath());
        }
        Collection<String> collection = Main.pref.getCollection("mappaint.icon.sources");
        for (String string : collection) {
            String[] stringArray = string.indexOf(61) >= 0 ? string.split("=", 2) : new String[]{"", string};
            if (!stringArray[0].isEmpty() && !styleSource.getPrefName().equals(stringArray[0])) continue;
            linkedList.add(stringArray[1]);
        }
        if (Main.pref.getBoolean("mappaint.icon.enable-defaults", true)) {
            linkedList.add("resource://images/styles/standard/");
            linkedList.add("resource://images/styles/");
        }
        return linkedList;
    }

    public static void readFromPreferences() {
        styles.clear();
        List<SourceEntry> list = MapPaintPreference.MapPaintPrefHelper.INSTANCE.get();
        for (SourceEntry sourceEntry : list) {
            StyleSource styleSource = MapPaintStyles.fromSourceEntry(sourceEntry);
            if (styleSource == null) continue;
            styles.add(styleSource);
        }
        for (StyleSource styleSource : styles.getStyleSources()) {
            MapPaintStyles.loadStyleForFirstTime(styleSource);
        }
        MapPaintStyles.fireMapPaintSylesUpdated();
    }

    private static void loadStyleForFirstTime(StyleSource styleSource) {
        long l = System.currentTimeMillis();
        styleSource.loadStyleSource();
        if (Main.pref.getBoolean("mappaint.auto_reload_local_styles", true) && styleSource.isLocal()) {
            try {
                Main.fileWatcher.registerStyleSource(styleSource);
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
        }
        if (Main.isDebugEnabled() || !styleSource.isValid()) {
            long l2 = System.currentTimeMillis() - l;
            String string = "Initializing map style " + styleSource.url + " completed in " + Utils.getDurationString(l2);
            if (!styleSource.isValid()) {
                Main.warn(string + " (" + styleSource.getErrors().size() + " errors, " + styleSource.getWarnings().size() + " warnings)");
            } else {
                Main.debug(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static StyleSource fromSourceEntry(SourceEntry var0) {
        var1_1 = null;
        try {
            block39: {
                var2_2 = new HashSet<String>();
                var2_2.addAll(Arrays.asList("application/xml, text/xml, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5".split(", ")));
                var2_2.addAll(Arrays.asList("text/x-mapcss, text/mapcss, text/css; q=0.9, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5".split(", ")));
                var1_1 = new CachedFile(var0.url).setHttpAccept(Utils.join(", ", var2_2));
                var3_4 = var1_1.findZipEntryPath("mapcss", "style");
                if (var3_4 != null) {
                    var0.isZip = true;
                    var0.zipEntryPath = var3_4;
                    var4_5 = new MapCSSStyleSource(var0);
                    return var4_5;
                }
                var3_4 = var1_1.findZipEntryPath("xml", "style");
                if (var3_4 != null) {
                    var4_6 = new XmlStyleSource(var0);
                    return var4_6;
                }
                if (Utils.hasExtension(var0.url, new String[]{"mapcss"})) {
                    var4_7 = new MapCSSStyleSource(var0);
                    return var4_7;
                }
                if (Utils.hasExtension(var0.url, new String[]{"xml"})) {
                    var4_8 = new XmlStyleSource(var0);
                    return var4_8;
                }
                var4_9 = new InputStreamReader(var1_1.getInputStream(), StandardCharsets.UTF_8);
                var5_10 = null;
                try {
                    block30: while (true) {
                        var6_11 = var4_9.read();
                        switch (var6_11) {
                            case -1: {
                                ** break;
lbl33:
                                // 1 sources

                                break block39;
                            }
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                continue block30;
                            }
                            case 60: {
                                var7_14 = new XmlStyleSource(var0);
                                return var7_14;
                            }
                            default: {
                                var7_15 = new MapCSSStyleSource(var0);
                                return var7_15;
                            }
                        }
                        break;
                    }
                }
                catch (Throwable var6_13) {
                    var5_10 = var6_13;
                    throw var6_13;
                }
                finally {
                    if (var4_9 != null) {
                        if (var5_10 != null) {
                            try {
                                var4_9.close();
                            }
                            catch (Throwable var6_12) {
                                var5_10.addSuppressed(var6_12);
                            }
                        } else {
                            var4_9.close();
                        }
                    }
                }
            }
            Main.warn("Could not detect style type. Using default (xml).");
            var4_9 = new XmlStyleSource(var0);
            return var4_9;
        }
        catch (IOException var2_3) {
            Main.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", new Object[]{var0.url, var2_3.toString()}));
            Main.error(var2_3);
        }
        finally {
            if (var1_1 != null) {
                var1_1.close();
            }
        }
        return null;
    }

    public static void reloadStyles(int ... nArray) {
        ArrayList<StyleSource> arrayList = new ArrayList<StyleSource>();
        List<StyleSource> list = styles.getStyleSources();
        for (int n : nArray) {
            arrayList.add(list.get(n));
        }
        Main.worker.submit(new MapPaintStyleLoader(arrayList));
    }

    public static void moveStyles(int[] nArray, int n) {
        if (!MapPaintStyles.canMoveStyles(nArray, n)) {
            return;
        }
        int[] nArray2 = Utils.copyArray(nArray);
        Arrays.sort(nArray2);
        ArrayList<StyleSource> arrayList = new ArrayList<StyleSource>(styles.getStyleSources());
        for (int n2 : nArray2) {
            StyleSource styleSource = (StyleSource)arrayList.get(n2);
            StyleSource styleSource2 = (StyleSource)arrayList.get(n2 + n);
            arrayList.set(n2, styleSource2);
            arrayList.set(n2 + n, styleSource);
        }
        styles.setStyleSources(arrayList);
        MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(arrayList);
        MapPaintStyles.fireMapPaintSylesUpdated();
        styles.clearCached();
        Main.map.mapView.repaint();
    }

    public static boolean canMoveStyles(int[] nArray, int n) {
        if (nArray.length == 0) {
            return false;
        }
        int[] nArray2 = Utils.copyArray(nArray);
        Arrays.sort(nArray2);
        if (n < 0) {
            return nArray2[0] >= -n;
        }
        if (n > 0) {
            return nArray2[nArray2.length - 1] <= styles.getStyleSources().size() - 1 - n;
        }
        return true;
    }

    public static void toggleStyleActive(int ... nArray) {
        List<StyleSource> list = styles.getStyleSources();
        for (int n : nArray) {
            StyleSource styleSource = list.get(n);
            styleSource.active = !styleSource.active;
        }
        MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(list);
        if (nArray.length == 1) {
            MapPaintStyles.fireMapPaintStyleEntryUpdated(nArray[0]);
        } else {
            MapPaintStyles.fireMapPaintSylesUpdated();
        }
        styles.clearCached();
        Main.map.mapView.repaint();
    }

    public static StyleSource addStyle(SourceEntry sourceEntry) {
        StyleSource styleSource = MapPaintStyles.fromSourceEntry(sourceEntry);
        if (styleSource != null) {
            styles.add(styleSource);
            MapPaintStyles.loadStyleForFirstTime(styleSource);
            MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(styles.getStyleSources());
            MapPaintStyles.fireMapPaintSylesUpdated();
            styles.clearCached();
            if (Main.isDisplayingMapView()) {
                Main.map.mapView.repaint();
            }
        }
        return styleSource;
    }

    public static void addMapPaintSylesUpdateListener(MapPaintSylesUpdateListener mapPaintSylesUpdateListener) {
        if (mapPaintSylesUpdateListener != null) {
            listeners.addIfAbsent(mapPaintSylesUpdateListener);
        }
    }

    public static void removeMapPaintSylesUpdateListener(MapPaintSylesUpdateListener mapPaintSylesUpdateListener) {
        listeners.remove(mapPaintSylesUpdateListener);
    }

    public static void fireMapPaintSylesUpdated() {
        for (MapPaintSylesUpdateListener mapPaintSylesUpdateListener : listeners) {
            mapPaintSylesUpdateListener.mapPaintStylesUpdated();
        }
    }

    public static void fireMapPaintStyleEntryUpdated(int n) {
        for (MapPaintSylesUpdateListener mapPaintSylesUpdateListener : listeners) {
            mapPaintSylesUpdateListener.mapPaintStyleEntryUpdated(n);
        }
    }

    public static interface MapPaintSylesUpdateListener {
        public void mapPaintStylesUpdated();

        public void mapPaintStyleEntryUpdated(int var1);
    }

    public static class MapPaintStyleLoader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private final Collection<StyleSource> sources;

        public MapPaintStyleLoader(Collection<StyleSource> collection) {
            super(I18n.tr("Reloading style sources", new Object[0]));
            this.sources = collection;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPaintStyles.fireMapPaintSylesUpdated();
                    styles.clearCached();
                    if (Main.isDisplayingMapView()) {
                        Main.map.mapView.preferenceChanged(null);
                        Main.map.mapView.repaint();
                    }
                }
            });
        }

        @Override
        protected void realRun() {
            ProgressMonitor progressMonitor = this.getProgressMonitor();
            progressMonitor.setTicksCount(this.sources.size());
            for (StyleSource styleSource : this.sources) {
                if (this.canceled) {
                    return;
                }
                progressMonitor.subTask(I18n.tr("loading style ''{0}''...", styleSource.getDisplayString()));
                styleSource.loadStyleSource();
                progressMonitor.worked(1);
            }
        }
    }

    public static class IconReference {
        public final String iconName;
        public final StyleSource source;

        public IconReference(String string, StyleSource styleSource) {
            this.iconName = string;
            this.source = styleSource;
        }

        public String toString() {
            return "IconReference{iconName='" + this.iconName + "' source='" + this.source.getDisplayString() + "'}";
        }
    }

    public static class TagKeyReference {
        public final String key;

        public TagKeyReference(String string) {
            this.key = string;
        }

        public String toString() {
            return "TagKeyReference{key='" + this.key + "'}";
        }
    }
}

