/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrument.ASTProber;
import com.oracle.truffle.api.instrument.EvalInstrumentListener;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeException;
import com.oracle.truffle.api.instrument.ProbeFailure;
import com.oracle.truffle.api.instrument.ProbeInstrument;
import com.oracle.truffle.api.instrument.ProbeListener;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.SimpleInstrumentListener;
import com.oracle.truffle.api.instrument.StandardAfterInstrumentListener;
import com.oracle.truffle.api.instrument.StandardBeforeInstrumentListener;
import com.oracle.truffle.api.instrument.StandardInstrumentListener;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.TagInstrument;
import com.oracle.truffle.api.instrument.WrapperNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Instrumenter {
    private static final boolean TRACE = false;
    private static final String TRACE_PREFIX = "Instrumenter: ";
    private static final PrintStream OUT = System.out;
    private final Object vm;
    Set<Tool> tools = new HashSet<Tool>();
    private final Set<ASTProber> astProbers = Collections.synchronizedSet(new LinkedHashSet());
    private final List<ProbeListener> probeListeners = new ArrayList<ProbeListener>();
    private final List<WeakReference<Probe>> probes = new ArrayList<WeakReference<Probe>>();
    @CompilerDirectives.CompilationFinal
    private TagInstrument.BeforeTagInstrument beforeTagInstrument = null;
    @CompilerDirectives.CompilationFinal
    private TagInstrument.AfterTagInstrument afterTagInstrument = null;
    static final AccessorInstrument ACCESSOR = new AccessorInstrument();
    private static Object testVM = null;

    private static void trace(String format, Object ... args) {
    }

    Instrumenter(Object vm) {
        this.vm = vm;
    }

    public Probe probe(Node node) {
        Node parent = node.getParent();
        if (node instanceof WrapperNode) {
            throw new ProbeException(ProbeFailure.Reason.WRAPPER_NODE, null, node, null);
        }
        if (parent == null) {
            throw new ProbeException(ProbeFailure.Reason.NO_PARENT, null, node, null);
        }
        if (parent instanceof WrapperNode) {
            WrapperNode wrapper = (WrapperNode)((Object)parent);
            return wrapper.getProbe();
        }
        if (!ACCESSOR.isInstrumentable(this.vm, node)) {
            throw new ProbeException(ProbeFailure.Reason.NOT_INSTRUMENTABLE, parent, node, null);
        }
        WrapperNode wrapper = this.createWrapperNode(node);
        if (wrapper == null || !(wrapper instanceof Node)) {
            throw new ProbeException(ProbeFailure.Reason.NO_WRAPPER, parent, node, wrapper);
        }
        Node wrapperNode = (Node)((Object)wrapper);
        if (!node.isSafelyReplaceableBy(wrapperNode)) {
            throw new ProbeException(ProbeFailure.Reason.WRAPPER_TYPE, parent, node, wrapper);
        }
        SourceSection sourceSection = wrapper.getChild().getSourceSection();
        ProbeNode probeNode = new ProbeNode();
        Class<? extends TruffleLanguage> l = ACCESSOR.findLanguage(wrapper.getChild().getRootNode());
        Probe probe = new Probe(this, l, probeNode, sourceSection);
        this.probes.add(new WeakReference<Probe>(probe));
        probeNode.probe = probe;
        wrapper.insertEventHandlerNode(probeNode);
        node.replace(wrapperNode);
        for (ProbeListener listener : this.probeListeners) {
            listener.newProbeInserted(probe);
        }
        return probe;
    }

    public void addProbeListener(ProbeListener listener) {
        assert (listener != null);
        this.probeListeners.add(listener);
    }

    public void removeProbeListener(ProbeListener listener) {
        this.probeListeners.remove(listener);
    }

    public Collection<Probe> findProbesTaggedAs(SyntaxTag tag) {
        ArrayList<Probe> taggedProbes = new ArrayList<Probe>();
        for (WeakReference<Probe> ref : this.probes) {
            Probe probe = (Probe)ref.get();
            if (probe == null || tag != null && !probe.isTaggedAs(tag)) continue;
            taggedProbes.add((Probe)ref.get());
        }
        return taggedProbes;
    }

    public void registerASTProber(ASTProber prober) {
        if (prober == null) {
            throw new IllegalArgumentException("Register non-null ASTProbers");
        }
        this.astProbers.add(prober);
    }

    public void unregisterASTProber(ASTProber prober) {
        this.astProbers.remove(prober);
    }

    public ProbeInstrument attach(Probe probe, SimpleInstrumentListener listener, String instrumentInfo) {
        assert (probe.getInstrumenter() == this);
        ProbeInstrument.SimpleInstrument instrument = new ProbeInstrument.SimpleInstrument(listener, instrumentInfo);
        probe.attach(instrument);
        return instrument;
    }

    public ProbeInstrument attach(Probe probe, StandardInstrumentListener listener, String instrumentInfo) {
        assert (probe.getInstrumenter() == this);
        ProbeInstrument.StandardInstrument instrument = new ProbeInstrument.StandardInstrument(listener, instrumentInfo);
        probe.attach(instrument);
        return instrument;
    }

    @Deprecated
    public ProbeInstrument attach(Probe probe, Class<? extends TruffleLanguage> languageClass, Source source, EvalInstrumentListener listener, String instrumentInfo) {
        return this.attach(probe, languageClass, source, listener, instrumentInfo, new String[0], new Object[0]);
    }

    public ProbeInstrument attach(Probe probe, Source source, EvalInstrumentListener listener, String instrumentInfo, Map<String, Object> parameters) {
        int size = parameters == null ? 0 : parameters.size();
        String[] names = new String[size];
        Object[] params = new Object[size];
        if (parameters != null) {
            int index = 0;
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                names[index] = entry.getKey();
                params[index] = entry.getValue();
                ++index;
            }
        }
        return this.attach(probe, null, source, listener, instrumentInfo, names, params);
    }

    private ProbeInstrument attach(Probe probe, Class<? extends TruffleLanguage> languageClass, Source source, EvalInstrumentListener listener, String instrumentInfo, String[] argumentNames, Object[] parameters) {
        assert (probe.getInstrumenter() == this);
        Class<? extends TruffleLanguage> foundLanguageClass = null;
        if (languageClass == null) {
            if (source.getMimeType() == null) {
                foundLanguageClass = ACCESSOR.findLanguage(probe);
            }
        } else {
            foundLanguageClass = languageClass;
        }
        ProbeInstrument.EvalInstrument instrument = new ProbeInstrument.EvalInstrument(foundLanguageClass, source, listener, instrumentInfo, argumentNames, parameters);
        probe.attach(instrument);
        return instrument;
    }

    public TagInstrument attach(SyntaxTag tag, StandardBeforeInstrumentListener listener, String instrumentInfo) {
        if (this.beforeTagInstrument != null) {
            throw new IllegalStateException("Only one 'before' TagInstrument at a time");
        }
        this.beforeTagInstrument = new TagInstrument.BeforeTagInstrument(this, tag, listener, instrumentInfo);
        this.notifyTagInstrumentChange();
        return this.beforeTagInstrument;
    }

    public TagInstrument attach(SyntaxTag tag, StandardAfterInstrumentListener listener, String instrumentInfo) {
        if (this.afterTagInstrument != null) {
            throw new IllegalStateException("Only one 'afater' TagInstrument at a time");
        }
        this.afterTagInstrument = new TagInstrument.AfterTagInstrument(this, tag, listener, instrumentInfo);
        this.notifyTagInstrumentChange();
        return this.afterTagInstrument;
    }

    public Tool install(Tool tool) {
        tool.install(this);
        return tool;
    }

    void executionStarted(Source s) {
    }

    void executionEnded() {
    }

    WrapperNode createWrapperNode(Node node) {
        return ACCESSOR.createWrapperNode(this.vm, node);
    }

    void tagAdded(Probe probe, SyntaxTag tag, Object tagValue) {
        for (ProbeListener listener : this.probeListeners) {
            listener.probeTaggedAs(probe, tag, tagValue);
        }
    }

    TagInstrument.BeforeTagInstrument getBeforeTagInstrument() {
        return this.beforeTagInstrument;
    }

    TagInstrument.AfterTagInstrument getAfterTagInstrument() {
        return this.afterTagInstrument;
    }

    void disposeBeforeTagInstrument() {
        this.beforeTagInstrument = null;
        this.notifyTagInstrumentChange();
    }

    void disposeAfterTagInstrument() {
        this.afterTagInstrument = null;
        this.notifyTagInstrumentChange();
    }

    private void notifyTagInstrumentChange() {
        for (WeakReference<Probe> ref : this.probes) {
            Probe probe = (Probe)ref.get();
            if (probe == null) continue;
            probe.notifyTagInstrumentsChanged();
        }
    }

    private void probeAST(RootNode rootNode) {
        if (!this.astProbers.isEmpty()) {
            String name = "<?>";
            SourceSection sourceSection = rootNode.getSourceSection();
            if (sourceSection != null) {
                Source source = sourceSection.getSource();
                name = source != null ? source.getShortName() : sourceSection.getShortDescription();
            }
            Instrumenter.trace("START %s", name);
            for (ProbeListener listener : this.probeListeners) {
                listener.startASTProbing(rootNode);
            }
            for (ASTProber prober : this.astProbers) {
                prober.probeAST(this, rootNode);
            }
            for (ProbeListener listener : this.probeListeners) {
                listener.endASTProbing(rootNode);
            }
            Instrumenter.trace("FINISHED %s", name);
        }
    }

    static final class AccessorInstrument
    extends Accessor {
        AccessorInstrument() {
        }

        @Override
        protected Instrumenter createInstrumenter(Object vm) {
            return new Instrumenter(vm);
        }

        @Override
        protected boolean isInstrumentable(Object vm, Node node) {
            return super.isInstrumentable(vm, node);
        }

        @Override
        protected WrapperNode createWrapperNode(Object vm, Node node) {
            return super.createWrapperNode(vm, node);
        }

        @Override
        protected Class<? extends TruffleLanguage> findLanguage(RootNode n) {
            return super.findLanguage(n);
        }

        @Override
        protected Class<? extends TruffleLanguage> findLanguage(Probe probe) {
            return probe.getLanguage();
        }

        @Override
        protected CallTarget parse(Class<? extends TruffleLanguage> languageClass, Source code, Node context, String ... argumentNames) throws IOException {
            return super.parse(languageClass, code, context, argumentNames);
        }

        @Override
        protected void probeAST(RootNode rootNode) {
            Instrumenter instrumenter = super.getInstrumenter(testVM);
            if (instrumenter != null) {
                instrumenter.probeAST(rootNode);
            }
        }
    }

    public static abstract class Tool {
        private ToolState toolState = ToolState.UNINSTALLED;
        private Instrumenter instrumenter;

        protected Tool() {
        }

        final void install(Instrumenter inst) {
            this.checkUninstalled();
            this.instrumenter = inst;
            if (this.internalInstall()) {
                this.toolState = ToolState.ENABLED;
            }
            this.instrumenter.tools.add(this);
        }

        public final boolean isEnabled() {
            return this.toolState == ToolState.ENABLED;
        }

        public final void setEnabled(boolean isEnabled) {
            this.checkInstalled();
            this.internalSetEnabled(isEnabled);
            this.toolState = isEnabled ? ToolState.ENABLED : ToolState.DISABLED;
        }

        public final void reset() {
            this.checkInstalled();
            this.internalReset();
        }

        public final void dispose() {
            this.checkInstalled();
            this.internalDispose();
            this.toolState = ToolState.DISPOSED;
            this.instrumenter.tools.remove(this);
        }

        protected abstract boolean internalInstall();

        protected void internalSetEnabled(boolean isEnabled) {
        }

        protected abstract void internalReset();

        protected abstract void internalDispose();

        protected final Instrumenter getInstrumenter() {
            return this.instrumenter;
        }

        private void checkInstalled() throws IllegalStateException {
            if (this.toolState == ToolState.UNINSTALLED) {
                throw new IllegalStateException("Tool " + this.getClass().getSimpleName() + " not yet installed");
            }
            if (this.toolState == ToolState.DISPOSED) {
                throw new IllegalStateException("Tool " + this.getClass().getSimpleName() + " has been disposed");
            }
        }

        private void checkUninstalled() {
            if (this.toolState != ToolState.UNINSTALLED) {
                throw new IllegalStateException("Tool " + this.getClass().getSimpleName() + " has already been installed");
            }
        }
    }

    private static enum ToolState {
        UNINSTALLED,
        ENABLED,
        DISABLED,
        DISPOSED;

    }
}

