/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.RespondToNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class ShouldDestructureNode
extends RubyNode {
    @Node.Child
    private RespondToNode respondToCheck;
    private final BranchProfile checkRespondProfile = BranchProfile.create();

    public ShouldDestructureNode(RubyContext context, SourceSection sourceSection, RespondToNode respondToCheck) {
        super(context, sourceSection);
        this.respondToCheck = respondToCheck;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        if (RubyArguments.getArgumentsCount(frame.getArguments()) != 1) {
            return false;
        }
        if (RubyGuards.isRubyArray(RubyArguments.getArgument(frame.getArguments(), 0))) {
            return true;
        }
        this.checkRespondProfile.enter();
        return this.respondToCheck.executeBoolean(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }
}

