/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rotate;

import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.module.PdfsamModule;
import org.pdfsam.rotate.RotateOptionsPane;
import org.pdfsam.rotate.RotateParametersBuilder;
import org.pdfsam.rotate.RotateSelectionPane;
import org.pdfsam.ui.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.prefix.PrefixPane;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.model.prefix.Prefix;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@PdfsamModule
public class RotateModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "rotate";
    private RotateSelectionPane selectionPane = new RotateSelectionPane("rotate");
    private RotateOptionsPane rotateOptions = new RotateOptionsPane();
    private BrowsableOutputDirectoryField destinationDirectoryField;
    private PdfDestinationPane destinationPane;
    private PrefixPane prefix = new PrefixPane();
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.OTHER).name(DefaultI18nContext.getInstance().i18n("Rotate")).description(DefaultI18nContext.getInstance().i18n("Rotate the pages of multiple PDF documents.")).priority(ModulePriority.DEFAULT.getPriority()).supportURL("http://www.pdfsam.org/rotate-pdf").build();

    @Inject
    public RotateModule(@Named(value="rotatefield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="rotatepane") PdfDestinationPane destinationPane) {
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
    }

    @Override
    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    protected RotateParametersBuilder getBuilder(Consumer<String> onError) {
        RotateParametersBuilder builder = new RotateParametersBuilder();
        this.selectionPane.apply(builder, onError);
        this.rotateOptions.apply(builder, onError);
        this.destinationDirectoryField.apply(builder, onError);
        this.destinationPane.apply(builder, onError);
        this.prefix.apply(builder, onError);
        return builder;
    }

    @Override
    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.rotateOptions.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo((Map)data);
        this.prefix.saveStateTo(data);
    }

    @Override
    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.rotateOptions.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom((Map)data);
        this.prefix.restoreStateFrom(data);
    }

    @Override
    protected Pane getInnerPanel(Pane footer) {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        TitledPane prefixTitled = Views.titledPane(DefaultI18nContext.getInstance().i18n("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(Prefix.FILENUMBER);
        TitledPane options = Views.titledPane(DefaultI18nContext.getInstance().i18n("Rotate settings"), (Node)this.rotateOptions);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, options, Views.titledPane(DefaultI18nContext.getInstance().i18n("Destination directory"), (Node)this.destinationPane), prefixTitled, footer});
        return pane;
    }

    @Override
    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @Override
    public Node graphic() {
        return new ImageView("rotate.png");
    }

    @Configuration
    public static class ModuleConfig {
        @Bean(name={"rotatefield"})
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Bean(name={"rotatepane"})
        public PdfDestinationPane destinationPane(@Named(value="rotatefield") BrowsableOutputDirectoryField outputField, UserContext userContext) {
            return new PdfDestinationPane(outputField, RotateModule.MODULE_ID, userContext);
        }
    }
}

