/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;

public final class JPXFilter
extends Filter {
    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        DecodeResult result = new DecodeResult(new COSDictionary());
        result.getParameters().addAll(parameters);
        BufferedImage image = this.readJPX(encoded, result);
        WritableRaster raster = image.getRaster();
        if (raster.getDataBuffer().getDataType() != 0) {
            throw new IOException("Not implemented: greater than 8-bit depth");
        }
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        decoded.write(buffer.getData());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readJPX(InputStream input, DecodeResult result) throws IOException {
        ImageReader reader = JPXFilter.findImageReader("JPEG2000", "Java Advanced Imaging (JAI) Image I/O Tools are not installed");
        ImageInputStream iis = null;
        try {
            BufferedImage image;
            iis = ImageIO.createImageInputStream(input);
            reader.setInput(iis, true, true);
            try {
                image = reader.read(0);
            }
            catch (Exception e) {
                throw new IOException("Could not read JPEG 2000 (JPX) image", e);
            }
            COSDictionary parameters = result.getParameters();
            int bpc = image.getColorModel().getPixelSize() / image.getRaster().getNumBands();
            parameters.setInt(COSName.BITS_PER_COMPONENT, bpc);
            if (!parameters.getBoolean(COSName.IMAGE_MASK, false)) {
                parameters.removeItem(COSName.DECODE);
            }
            parameters.setInt(COSName.WIDTH, image.getWidth());
            parameters.setInt(COSName.HEIGHT, image.getHeight());
            if (!parameters.containsKey(COSName.COLORSPACE)) {
                // empty if block
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (iis != null) {
                iis.close();
            }
            reader.dispose();
        }
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) {
        throw new UnsupportedOperationException("JPX encoding not implemented");
    }
}

