/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.blend;

import java.awt.Graphics;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public final class SoftMaskPaint
implements Paint {
    private final Paint parentPaint;
    private final Raster softMaskRaster;

    public SoftMaskPaint(Paint parentPaint, Raster softMaskRaster) {
        this.parentPaint = parentPaint;
        this.softMaskRaster = softMaskRaster;
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform at, RenderingHints hints) {
        PaintContext parentContext = this.parentPaint.createContext(null, deviceBounds, userBounds, at, hints);
        return new Context(parentContext);
    }

    private class Context
    implements PaintContext {
        private final PaintContext parentContext;
        private final ColorModel colorModel;
        private final int numColorComponents;
        private final ColorModel parentColorModel;

        Context(PaintContext parentContext) {
            this.parentContext = parentContext;
            this.parentColorModel = parentContext.getColorModel();
            this.colorModel = parentContext.getColorModel().hasAlpha() ? this.parentColorModel : new ComponentColorModel(parentContext.getColorModel().getColorSpace(), true, false, 1, 0);
            this.numColorComponents = this.colorModel.getNumColorComponents();
        }

        @Override
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            WritableRaster result;
            Raster parentRaster = this.parentContext.getRaster(x, y, w, h);
            int parentMinX = parentRaster.getMinX();
            int parentMinY = parentRaster.getMinY();
            if (parentRaster instanceof WritableRaster) {
                if (this.parentColorModel.equals(this.colorModel)) {
                    result = parentRaster.createCompatibleWritableRaster();
                    result.setDataElements(-parentMinX, -parentMinY, parentRaster);
                } else {
                    BufferedImage parentImage = new BufferedImage(this.parentColorModel, (WritableRaster)parentRaster, this.parentColorModel.isAlphaPremultiplied(), null);
                    result = Raster.createWritableRaster(this.colorModel.createCompatibleSampleModel(w, h), new Point(0, 0));
                    BufferedImage resultImage = new BufferedImage(this.colorModel, result, false, null);
                    resultImage.getGraphics().drawImage(parentImage, 0, 0, null);
                    Graphics graphics = resultImage.getGraphics();
                    graphics.drawImage(parentImage, 0, 0, null);
                    graphics.dispose();
                }
            } else {
                result = Raster.createInterleavedRaster(0, w, h, this.getColorModel().getNumComponents(), new Point(0, 0));
                ColorConvertOp colorConvertOp = new ColorConvertOp(this.parentColorModel.getColorSpace(), this.colorModel.getColorSpace(), null);
                colorConvertOp.filter(parentRaster, result);
            }
            int softMaskMinX = SoftMaskPaint.this.softMaskRaster.getMinX();
            int softMaskMinY = SoftMaskPaint.this.softMaskRaster.getMinY();
            int softMaskMaxX = softMaskMinX + SoftMaskPaint.this.softMaskRaster.getWidth();
            int softMaskMaxY = softMaskMinY + SoftMaskPaint.this.softMaskRaster.getHeight();
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    int rx = x + i;
                    int ry = y + j;
                    int alpha = rx >= softMaskMinX && rx < softMaskMaxX && ry >= softMaskMinY && ry < softMaskMaxY ? SoftMaskPaint.this.softMaskRaster.getSample(rx, ry, 0) : 0;
                    alpha = alpha * result.getSample(i, j, this.numColorComponents) / 255;
                    result.setSample(i, j, this.numColorComponents, alpha);
                }
            }
            return result;
        }

        @Override
        public void dispose() {
        }
    }
}

