/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.config;

import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.constants.SystemInfo;
import com.baselet.control.enums.Os;
import com.baselet.control.enums.Program;
import com.baselet.control.enums.RuntimeType;
import java.awt.Point;
import java.io.File;
import javax.swing.UIManager;

public class Config {
    private static Config instance = new Config();
    private final String DEFAULT_FILE_HOME;
    private String uiManager;
    private String openFileHome;
    private String saveFileHome;
    private String programVersion;
    private String lastUsedPalette;
    private String pdfExportFont;
    private String pdfExportFontBold;
    private String pdfExportFontItalic;
    private String pdfExportFontBoldItalic;
    private boolean checkForUpdates;
    private int printPadding;
    private Point program_location;
    private Dimension program_size;
    private int mail_split_position;
    private int right_split_position;
    private int main_split_position;
    private boolean enable_custom_elements;
    private boolean show_grid;
    private boolean start_maximized;
    private String defaultFontFamily;
    private Integer defaultFontsize;
    private Integer propertiesPanelFontsize;

    public static Config getInstance() {
        return instance;
    }

    public Config() {
        this.openFileHome = this.DEFAULT_FILE_HOME = System.getProperty("user.dir");
        this.saveFileHome = this.DEFAULT_FILE_HOME;
        this.lastUsedPalette = "";
        this.pdfExportFont = "";
        this.pdfExportFontBold = "";
        this.pdfExportFontItalic = "";
        this.pdfExportFontBoldItalic = "";
        this.checkForUpdates = true;
        this.printPadding = 20;
        this.program_location = new Point(5, 5);
        this.program_size = new Dimension(960, 750);
        this.mail_split_position = 250;
        this.right_split_position = 400;
        this.main_split_position = 600;
        this.enable_custom_elements = true;
        this.show_grid = false;
        this.start_maximized = false;
        this.defaultFontFamily = "SansSerif";
        this.defaultFontsize = 14;
        this.propertiesPanelFontsize = 11;
        this.initUiManager();
    }

    private void initUiManager() {
        this.uiManager = SystemInfo.OS == Os.MAC ? "javax.swing.plaf.metal.MetalLookAndFeel" : (Program.getInstance().getRuntimeType() == RuntimeType.ECLIPSE_PLUGIN && UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") ? "javax.swing.plaf.metal.MetalLookAndFeel" : UIManager.getSystemLookAndFeelClassName());
    }

    public String getUiManager() {
        return this.uiManager;
    }

    public void setUiManager(String uiManager) {
        this.uiManager = uiManager;
    }

    public String getOpenFileHome() {
        if (new File(this.openFileHome).exists()) {
            return this.openFileHome;
        }
        return this.DEFAULT_FILE_HOME;
    }

    public void setOpenFileHome(String openFileHome) {
        this.openFileHome = openFileHome;
    }

    public String getSaveFileHome() {
        if (new File(this.saveFileHome).exists()) {
            return this.saveFileHome;
        }
        return this.DEFAULT_FILE_HOME;
    }

    public void setSaveFileHome(String saveFileHome) {
        this.saveFileHome = saveFileHome;
    }

    public void setProgramVersion(String cfgVersion) {
        this.programVersion = cfgVersion;
    }

    public String getProgramVersion() {
        return this.programVersion;
    }

    public String getLastUsedPalette() {
        return this.lastUsedPalette;
    }

    public void setLastUsedPalette(String lastUsedPalette) {
        this.lastUsedPalette = lastUsedPalette;
    }

    public String getPdfExportFont() {
        return this.pdfExportFont;
    }

    public void setPdfExportFont(String pdfExportFont) {
        this.pdfExportFont = pdfExportFont;
    }

    public String getPdfExportFontBold() {
        return this.pdfExportFontBold;
    }

    public void setPdfExportFontBold(String pdfExportFontBold) {
        this.pdfExportFontBold = pdfExportFontBold;
    }

    public String getPdfExportFontItalic() {
        return this.pdfExportFontItalic;
    }

    public void setPdfExportFontItalic(String pdfExportFontItalic) {
        this.pdfExportFontItalic = pdfExportFontItalic;
    }

    public String getPdfExportFontBoldItalic() {
        return this.pdfExportFontBoldItalic;
    }

    public void setPdfExportFontBoldItalic(String pdfExportFontBoldItalic) {
        this.pdfExportFontBoldItalic = pdfExportFontBoldItalic;
    }

    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
    }

    public int getPrintPadding() {
        return this.printPadding;
    }

    public void setPrintPadding(int printPadding) {
        this.printPadding = printPadding;
    }

    public Point getProgram_location() {
        return this.program_location;
    }

    public void setProgram_location(Point program_location) {
        this.program_location = program_location;
    }

    public Dimension getProgram_size() {
        return this.program_size;
    }

    public void setProgram_size(Dimension program_size) {
        this.program_size = program_size;
    }

    public int getMail_split_position() {
        return this.mail_split_position;
    }

    public void setMail_split_position(int mail_split_position) {
        this.mail_split_position = mail_split_position;
    }

    public int getRight_split_position() {
        return this.right_split_position;
    }

    public void setRight_split_position(int right_split_position) {
        this.right_split_position = right_split_position;
    }

    public int getMain_split_position() {
        return this.main_split_position;
    }

    public void setMain_split_position(int main_split_position) {
        this.main_split_position = main_split_position;
    }

    public boolean isEnable_custom_elements() {
        return this.enable_custom_elements;
    }

    public void setEnable_custom_elements(boolean enable_custom_elements) {
        this.enable_custom_elements = enable_custom_elements;
    }

    public boolean isShow_grid() {
        return this.show_grid;
    }

    public void setShow_grid(boolean show_grid) {
        this.show_grid = show_grid;
    }

    public boolean isStart_maximized() {
        return this.start_maximized;
    }

    public void setStart_maximized(boolean start_maximized) {
        this.start_maximized = start_maximized;
    }

    public String getDefaultFontFamily() {
        return this.defaultFontFamily;
    }

    public void setDefaultFontFamily(String defaultFontFamily) {
        this.defaultFontFamily = defaultFontFamily;
    }

    public Integer getDefaultFontsize() {
        return this.defaultFontsize;
    }

    public void setDefaultFontsize(Integer defaultFontsize) {
        this.defaultFontsize = defaultFontsize;
    }

    public Integer getPropertiesPanelFontsize() {
        return this.propertiesPanelFontsize;
    }

    public void setPropertiesPanelFontsize(Integer propertiesPanelFontsize) {
        this.propertiesPanelFontsize = propertiesPanelFontsize;
    }
}

