/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.DataPusher;
import com.sun.media.sound.Toolkit;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class JavaSoundAudioClip
implements AudioClip,
MetaEventListener,
LineListener {
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 16384;
    private long lastPlayCall = 0L;
    private static final int MINIMUM_PLAY_DELAY = 30;
    private byte[] loadedAudio = null;
    private int loadedAudioByteLength = 0;
    private AudioFormat loadedAudioFormat = null;
    private AutoClosingClip clip = null;
    private boolean clipLooping = false;
    private DataPusher datapusher = null;
    private Sequencer sequencer = null;
    private Sequence sequence = null;
    private boolean sequencerloop = false;
    private static final long CLIP_THRESHOLD = 0x100000L;
    private static final int STREAM_BUFFER_SIZE = 1024;

    public JavaSoundAudioClip(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        bufferedInputStream.mark(1024);
        boolean bl = false;
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);
            bl = this.loadAudioData(audioInputStream);
            if (bl) {
                bl = false;
                if ((long)this.loadedAudioByteLength < 0x100000L) {
                    bl = this.createClip();
                }
                if (!bl) {
                    bl = this.createSourceDataLine();
                }
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            try {
                MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(bufferedInputStream);
                bl = this.createSequencer(bufferedInputStream);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                bl = false;
            }
        }
        if (!bl) {
            throw new IOException("Unable to create AudioClip from input stream");
        }
    }

    @Override
    public synchronized void play() {
        this.startImpl(false);
    }

    @Override
    public synchronized void loop() {
        this.startImpl(true);
    }

    private synchronized void startImpl(boolean bl) {
        block17: {
            long l = System.currentTimeMillis();
            long l2 = l - this.lastPlayCall;
            if (l2 < 30L) {
                return;
            }
            this.lastPlayCall = l;
            try {
                if (this.clip != null) {
                    if (!this.clip.isOpen()) {
                        this.clip.open(this.loadedAudioFormat, this.loadedAudio, 0, this.loadedAudioByteLength);
                    } else {
                        this.clip.flush();
                        if (bl != this.clipLooping) {
                            this.clip.stop();
                        }
                    }
                    this.clip.setFramePosition(0);
                    if (bl) {
                        this.clip.loop(-1);
                    } else {
                        this.clip.start();
                    }
                    this.clipLooping = bl;
                    break block17;
                }
                if (this.datapusher != null) {
                    this.datapusher.start(bl);
                    break block17;
                }
                if (this.sequencer == null) break block17;
                this.sequencerloop = bl;
                if (this.sequencer.isRunning()) {
                    this.sequencer.setMicrosecondPosition(0L);
                }
                if (!this.sequencer.isOpen()) {
                    try {
                        this.sequencer.open();
                        this.sequencer.setSequence(this.sequence);
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        // empty catch block
                    }
                }
                this.sequencer.addMetaEventListener(this);
                try {
                    this.sequencer.start();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.lastPlayCall = 0L;
        if (this.clip != null) {
            try {
                this.clip.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.clip.stop();
            }
            catch (Exception exception) {}
        } else if (this.datapusher != null) {
            this.datapusher.stop();
        } else if (this.sequencer != null) {
            try {
                this.sequencerloop = false;
                this.sequencer.addMetaEventListener(this);
                this.sequencer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sequencer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void update(LineEvent lineEvent) {
    }

    @Override
    public synchronized void meta(MetaMessage metaMessage) {
        if (metaMessage.getType() == 47) {
            if (this.sequencerloop) {
                this.sequencer.setMicrosecondPosition(0L);
                this.loop();
            } else {
                this.stop();
            }
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    protected void finalize() {
        if (this.clip != null) {
            this.clip.close();
        }
        if (this.datapusher != null) {
            this.datapusher.close();
        }
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    private boolean loadAudioData(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        if ((audioInputStream = Toolkit.getPCMConvertedAudioInputStream(audioInputStream)) == null) {
            return false;
        }
        this.loadedAudioFormat = audioInputStream.getFormat();
        long l = audioInputStream.getFrameLength();
        int n = this.loadedAudioFormat.getFrameSize();
        long l2 = -1L;
        if (l != -1L && l > 0L && n != -1 && n > 0) {
            l2 = l * (long)n;
        }
        if (l2 != -1L) {
            this.readStream(audioInputStream, l2);
        } else {
            this.readStream(audioInputStream);
        }
        return true;
    }

    private void readStream(AudioInputStream audioInputStream, long l) throws IOException {
        int n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        this.loadedAudio = new byte[n];
        this.loadedAudioByteLength = 0;
        while (true) {
            int n2;
            if ((n2 = audioInputStream.read(this.loadedAudio, this.loadedAudioByteLength, n - this.loadedAudioByteLength)) <= 0) break;
            this.loadedAudioByteLength += n2;
        }
        audioInputStream.close();
    }

    private void readStream(AudioInputStream audioInputStream) throws IOException {
        DirectBAOS directBAOS = new DirectBAOS();
        byte[] byArray = new byte[16384];
        int n = 0;
        int n2 = 0;
        while (true) {
            if ((n = audioInputStream.read(byArray, 0, byArray.length)) <= 0) break;
            n2 += n;
            directBAOS.write(byArray, 0, n);
        }
        audioInputStream.close();
        this.loadedAudio = directBAOS.getInternalBuffer();
        this.loadedAudioByteLength = n2;
    }

    private boolean createClip() {
        try {
            DataLine.Info info = new DataLine.Info(Clip.class, this.loadedAudioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                return false;
            }
            Line line = AudioSystem.getLine(info);
            if (!(line instanceof AutoClosingClip)) {
                return false;
            }
            this.clip = (AutoClosingClip)line;
            this.clip.setAutoClosing(true);
        }
        catch (Exception exception) {
            return false;
        }
        return this.clip != null;
    }

    private boolean createSourceDataLine() {
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.loadedAudioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                return false;
            }
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.datapusher = new DataPusher(sourceDataLine, this.loadedAudioFormat, this.loadedAudio, this.loadedAudioByteLength);
        }
        catch (Exception exception) {
            return false;
        }
        return this.datapusher != null;
    }

    private boolean createSequencer(BufferedInputStream bufferedInputStream) throws IOException {
        try {
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            return false;
        }
        if (this.sequencer == null) {
            return false;
        }
        try {
            this.sequence = MidiSystem.getSequence(bufferedInputStream);
            if (this.sequence == null) {
                return false;
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return false;
        }
        return true;
    }

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        DirectBAOS() {
        }

        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }
}

