/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Init {
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";
    private static Logger log = Logger.getLogger(Init.class.getName());
    private static boolean alreadyInitialized = false;

    public static final synchronized boolean isInitialized() {
        return alreadyInitialized;
    }

    public static synchronized void init() {
        if (alreadyInitialized) {
            return;
        }
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                String string = System.getProperty("com.sun.org.apache.xml.internal.security.resource.config");
                if (string == null) {
                    return null;
                }
                return this.getClass().getResourceAsStream(string);
            }
        });
        if (inputStream == null) {
            Init.dynamicInit();
        } else {
            Init.fileInit(inputStream);
        }
        alreadyInitialized = true;
    }

    private static void dynamicInit() {
        I18n.init("en", "US");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Registering default algorithms");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws XMLSecurityException {
                    ElementProxy.registerDefaultPrefixes();
                    Transform.registerDefaultAlgorithms();
                    SignatureAlgorithm.registerDefaultAlgorithms();
                    JCEMapper.registerDefaultAlgorithms();
                    Canonicalizer.registerDefaultAlgorithms();
                    ResourceResolver.registerDefaultResolvers();
                    KeyResolver.registerDefaultResolvers();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            XMLSecurityException xMLSecurityException = (XMLSecurityException)privilegedActionException.getException();
            log.log(Level.SEVERE, xMLSecurityException.getMessage(), xMLSecurityException);
            xMLSecurityException.printStackTrace();
        }
    }

    private static void fileInit(InputStream inputStream) {
        try {
            Node node;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            for (node = document.getFirstChild(); node != null && !"Configuration".equals(node.getLocalName()); node = node.getNextSibling()) {
            }
            if (node == null) {
                log.log(Level.SEVERE, "Error in reading configuration file - Configuration element not found");
                return;
            }
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Object[] objectArray;
                String string;
                Object object;
                Object object2;
                Element[] elementArray;
                Object object3;
                if (1 != node2.getNodeType()) continue;
                String string2 = node2.getLocalName();
                if (string2.equals("ResourceBundles")) {
                    object3 = (Element[])node2;
                    elementArray = object3.getAttributeNode("defaultLanguageCode");
                    object2 = object3.getAttributeNode("defaultCountryCode");
                    object = elementArray == null ? null : elementArray.getNodeValue();
                    string = object2 == null ? null : object2.getNodeValue();
                    I18n.init((String)object, string);
                }
                if (string2.equals("CanonicalizationMethods")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "CanonicalizationMethod");
                    for (int i = 0; i < ((Element[])object3).length; ++i) {
                        object2 = object3[i].getAttributeNS(null, "URI");
                        object = object3[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            Canonicalizer.register((String)object2, (String)object);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.log(Level.FINE, "Canonicalizer.register(" + (String)object2 + ", " + (String)object + ")");
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object2, object};
                            log.log(Level.SEVERE, I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                    }
                }
                if (string2.equals("TransformAlgorithms")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "TransformAlgorithm");
                    for (int i = 0; i < ((Element[])object3).length; ++i) {
                        object2 = object3[i].getAttributeNS(null, "URI");
                        object = object3[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            Transform.register((String)object2, (String)object);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.log(Level.FINE, "Transform.register(" + (String)object2 + ", " + (String)object + ")");
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object2, object};
                            log.log(Level.SEVERE, I18n.translate("algorithm.classDoesNotExist", objectArray));
                            continue;
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            log.log(Level.WARNING, "Not able to found dependencies for algorithm, I'll keep working.");
                        }
                    }
                }
                if ("JCEAlgorithmMappings".equals(string2) && (object3 = ((Element)node2).getElementsByTagName("Algorithms").item(0)) != null) {
                    elementArray = XMLUtils.selectNodes(object3.getFirstChild(), CONF_NS, "Algorithm");
                    for (int i = 0; i < elementArray.length; ++i) {
                        object = elementArray[i];
                        string = object.getAttribute("URI");
                        JCEMapper.register(string, new JCEMapper.Algorithm((Element)object));
                    }
                }
                if (string2.equals("SignatureAlgorithms")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "SignatureAlgorithm");
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        object2 = object3[i].getAttributeNS(null, "URI");
                        object = object3[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            SignatureAlgorithm.register((String)object2, (String)object);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.log(Level.FINE, "SignatureAlgorithm.register(" + (String)object2 + ", " + (String)object + ")");
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object2, object};
                            log.log(Level.SEVERE, I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                    }
                }
                if (string2.equals("ResourceResolvers")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "Resolver");
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        object2 = object3[i].getAttributeNS(null, "JAVACLASS");
                        object = object3[i].getAttributeNS(null, "DESCRIPTION");
                        if (object != null && ((String)object).length() > 0) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Register Resolver: " + (String)object2 + ": " + (String)object);
                            }
                        } else if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Register Resolver: " + (String)object2 + ": For unknown purposes");
                        }
                        try {
                            ResourceResolver.register((String)object2);
                            continue;
                        }
                        catch (Throwable throwable) {
                            log.log(Level.WARNING, "Cannot register:" + (String)object2 + " perhaps some needed jars are not installed", throwable);
                        }
                    }
                }
                if (string2.equals("KeyResolver")) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "Resolver");
                    ArrayList<String> arrayList = new ArrayList<String>(((Object)object3).length);
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        object = object3[i].getAttributeNS(null, "JAVACLASS");
                        string = object3[i].getAttributeNS(null, "DESCRIPTION");
                        if (string != null && string.length() > 0) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Register Resolver: " + (String)object + ": " + string);
                            }
                        } else if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Register Resolver: " + (String)object + ": For unknown purposes");
                        }
                        arrayList.add((String)object);
                    }
                    KeyResolver.registerClassNames(arrayList);
                }
                if (!string2.equals("PrefixMappings")) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Now I try to bind prefixes:");
                }
                object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "PrefixMapping");
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    object2 = object3[i].getAttributeNS(null, "namespace");
                    object = object3[i].getAttributeNS(null, "prefix");
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Now I try to bind " + (String)object + " to " + (String)object2);
                    }
                    ElementProxy.setDefaultPrefix((String)object2, (String)object);
                }
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Bad: ", exception);
            exception.printStackTrace();
        }
    }
}

