/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetEvent;
import java.util.List;

public class DropTargetDropEvent
extends DropTargetEvent {
    private static final long serialVersionUID = -1721911170440459322L;
    private static final Point zero = new Point(0, 0);
    private Point location = zero;
    private int actions = 0;
    private int dropAction = 0;
    private boolean isLocalTx = false;

    public DropTargetDropEvent(DropTargetContext dropTargetContext, Point point, int n, int n2) {
        super(dropTargetContext);
        if (point == null) {
            throw new NullPointerException("cursorLocn");
        }
        if (n != 0 && n != 1 && n != 2 && n != 0x40000000) {
            throw new IllegalArgumentException("dropAction = " + n);
        }
        if ((n2 & 0xBFFFFFFC) != 0) {
            throw new IllegalArgumentException("srcActions");
        }
        this.location = point;
        this.actions = n2;
        this.dropAction = n;
    }

    public DropTargetDropEvent(DropTargetContext dropTargetContext, Point point, int n, int n2, boolean bl) {
        this(dropTargetContext, point, n, n2);
        this.isLocalTx = bl;
    }

    public Point getLocation() {
        return this.location;
    }

    public DataFlavor[] getCurrentDataFlavors() {
        return this.getDropTargetContext().getCurrentDataFlavors();
    }

    public List<DataFlavor> getCurrentDataFlavorsAsList() {
        return this.getDropTargetContext().getCurrentDataFlavorsAsList();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.getDropTargetContext().isDataFlavorSupported(dataFlavor);
    }

    public int getSourceActions() {
        return this.actions;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    public Transferable getTransferable() {
        return this.getDropTargetContext().getTransferable();
    }

    public void acceptDrop(int n) {
        this.getDropTargetContext().acceptDrop(n);
    }

    public void rejectDrop() {
        this.getDropTargetContext().rejectDrop();
    }

    public void dropComplete(boolean bl) {
        this.getDropTargetContext().dropComplete(bl);
    }

    public boolean isLocalTransfer() {
        return this.isLocalTx;
    }
}

