/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class BufferedWriter
extends Writer {
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;
    private String lineSeparator;

    public BufferedWriter(Writer writer) {
        this(writer, defaultCharBufferSize);
    }

    public BufferedWriter(Writer writer, int n) {
        super(writer);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = writer;
        this.cb = new char[n];
        this.nChars = n;
        this.nextChar = 0;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar == 0) {
                return;
            }
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                this.flushBuffer();
            }
            this.cb[this.nextChar++] = (char)n;
        }
    }

    private int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (n2 >= this.nChars) {
                this.flushBuffer();
                this.out.write(cArray, n, n2);
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = this.min(this.nChars - this.nextChar, n4 - n3);
                System.arraycopy(cArray, n3, this.cb, this.nextChar, n5);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = this.min(this.nChars - this.nextChar, n4 - n3);
                string.getChars(n3, n3 + n5, this.cb, this.nextChar);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            try (Writer writer = this.out;){
                this.flushBuffer();
            }
            finally {
                this.out = null;
                this.cb = null;
            }
        }
    }
}

