/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;

public class AnnotationValueImpl
implements AnnotationValue,
TypeIds {
    private static final int T_AnnotationMirror = -1;
    private static final int T_EnumConstant = -2;
    private static final int T_ClassObject = -3;
    private static final int T_ArrayType = -4;
    private final BaseProcessingEnvImpl _env;
    private final Object _value;
    private final int _kind;

    public AnnotationValueImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, Object object, TypeBinding typeBinding) {
        this._env = baseProcessingEnvImpl;
        int[] nArray = new int[1];
        if (typeBinding == null) {
            this._value = this.convertToMirrorType(object, typeBinding, nArray);
            this._kind = nArray[0];
        } else if (typeBinding.isArrayType()) {
            ArrayList<AnnotationValueImpl> arrayList = null;
            TypeBinding typeBinding2 = ((ArrayBinding)typeBinding).elementsType();
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                arrayList = new ArrayList(objectArray.length);
                for (Object object2 : objectArray) {
                    arrayList.add(new AnnotationValueImpl(this._env, object2, typeBinding2));
                }
            } else {
                arrayList = new ArrayList<AnnotationValueImpl>(1);
                arrayList.add(new AnnotationValueImpl(this._env, object, typeBinding2));
            }
            this._value = Collections.unmodifiableList(arrayList);
            this._kind = -4;
        } else {
            this._value = this.convertToMirrorType(object, typeBinding, nArray);
            this._kind = nArray[0];
        }
    }

    private Object convertToMirrorType(Object object, TypeBinding typeBinding, int[] nArray) {
        if (typeBinding == null) {
            nArray[0] = 11;
            return "<error>";
        }
        if (typeBinding instanceof BaseTypeBinding || typeBinding.id == 11) {
            if (object == null) {
                if (typeBinding instanceof BaseTypeBinding || typeBinding.id == 11) {
                    nArray[0] = 11;
                    return "<error>";
                }
                if (typeBinding.isAnnotationType()) {
                    nArray[0] = -1;
                    return this._env.getFactory().newAnnotationMirror(null);
                }
            } else if (object instanceof Constant) {
                if (typeBinding instanceof BaseTypeBinding) {
                    nArray[0] = ((BaseTypeBinding)typeBinding).id;
                } else if (typeBinding.id == 11) {
                    nArray[0] = ((Constant)object).typeID();
                } else {
                    nArray[0] = 11;
                    return "<error>";
                }
                switch (nArray[0]) {
                    case 5: {
                        return ((Constant)object).booleanValue();
                    }
                    case 3: {
                        return ((Constant)object).byteValue();
                    }
                    case 2: {
                        return Character.valueOf(((Constant)object).charValue());
                    }
                    case 8: {
                        return ((Constant)object).doubleValue();
                    }
                    case 9: {
                        return Float.valueOf(((Constant)object).floatValue());
                    }
                    case 10: {
                        try {
                            if (object instanceof LongConstant || object instanceof DoubleConstant || object instanceof FloatConstant) {
                                nArray[0] = 11;
                                return "<error>";
                            }
                            return ((Constant)object).intValue();
                        }
                        catch (ShouldNotImplement shouldNotImplement) {
                            nArray[0] = 11;
                            return "<error>";
                        }
                    }
                    case 11: {
                        return ((Constant)object).stringValue();
                    }
                    case 7: {
                        return ((Constant)object).longValue();
                    }
                    case 4: {
                        return ((Constant)object).shortValue();
                    }
                }
            }
        } else {
            if (typeBinding.isEnum()) {
                if (object instanceof FieldBinding) {
                    nArray[0] = -2;
                    return (VariableElement)this._env.getFactory().newElement((FieldBinding)object);
                }
                nArray[0] = 11;
                return "<error>";
            }
            if (typeBinding.isAnnotationType()) {
                if (object instanceof AnnotationBinding) {
                    nArray[0] = -1;
                    return this._env.getFactory().newAnnotationMirror((AnnotationBinding)object);
                }
            } else if (object instanceof TypeBinding) {
                nArray[0] = -3;
                return this._env.getFactory().newTypeMirror((TypeBinding)object);
            }
        }
        nArray[0] = 11;
        return "<error>";
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
        switch (this._kind) {
            case 5: {
                return annotationValueVisitor.visitBoolean((Boolean)this._value, p);
            }
            case 3: {
                return annotationValueVisitor.visitByte((Byte)this._value, p);
            }
            case 2: {
                return annotationValueVisitor.visitChar(((Character)this._value).charValue(), p);
            }
            case 8: {
                return annotationValueVisitor.visitDouble((Double)this._value, p);
            }
            case 9: {
                return annotationValueVisitor.visitFloat(((Float)this._value).floatValue(), p);
            }
            case 10: {
                return annotationValueVisitor.visitInt((Integer)this._value, p);
            }
            case 11: {
                return annotationValueVisitor.visitString((String)this._value, p);
            }
            case 7: {
                return annotationValueVisitor.visitLong((Long)this._value, p);
            }
            case 4: {
                return annotationValueVisitor.visitShort((Short)this._value, p);
            }
            case -2: {
                return annotationValueVisitor.visitEnumConstant((VariableElement)this._value, p);
            }
            case -3: {
                return annotationValueVisitor.visitType((TypeMirror)this._value, p);
            }
            case -1: {
                return annotationValueVisitor.visitAnnotation((AnnotationMirror)this._value, p);
            }
            case -4: {
                return annotationValueVisitor.visitArray((List)this._value, p);
            }
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object instanceof AnnotationValueImpl) {
            return this._value.equals(((AnnotationValueImpl)object)._value);
        }
        return false;
    }

    public int hashCode() {
        return this._value.hashCode() + this._kind;
    }

    @Override
    public String toString() {
        if (null == this._value) {
            return "null";
        }
        return this._value.toString();
    }
}

