/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.Vector;

public class MultiColumn
extends BorderPanel
implements CbScrollbarCallback {
    MultiColumnCallback callback;
    String[] title;
    boolean adjustable = true;
    boolean drawlines = true;
    Color[][] colors = null;
    boolean enabled = true;
    boolean multiselect = false;
    int[] cpos;
    float[] cwidth;
    Vector[] list;
    CbScrollbar sb;
    int width;
    int height;
    Insets in;
    int sbwidth;
    int th;
    Image bim;
    Graphics bg;
    Font font = new Font("timesRoman", 0, 12);
    FontMetrics fnm;
    int coldrag = -1;
    int sel = -1;
    int[] sels = new int[0];
    int top = 0;
    long last;
    int rowh = 16;
    Event last_event;
    int sortcol;
    int sortdir;

    MultiColumn(String[] stringArray) {
        super(3, Util.dark_edge_hi, Util.body_hi);
        int n;
        this.title = new String[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.title[n] = stringArray[n];
        }
        this.list = new Vector[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.list[n] = new Vector();
        }
        this.cwidth = new float[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.cwidth[n] = 1.0f / (float)stringArray.length;
        }
        this.cpos = new int[stringArray.length + 1];
        this.setLayout(null);
        this.sb = new CbScrollbar(0, this);
        this.add(this.sb);
    }

    MultiColumn(String[] stringArray, MultiColumnCallback multiColumnCallback) {
        this(stringArray);
        this.callback = multiColumnCallback;
    }

    void addItem(Object[] objectArray) {
        for (int i = 0; i < this.title.length; ++i) {
            this.list[i].addElement(objectArray[i]);
        }
        this.repaint();
        this.compscroll();
    }

    void addItems(Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < this.title.length; ++j) {
                this.list[j].addElement(objectArray[i][j]);
            }
        }
        this.repaint();
        this.compscroll();
    }

    void modifyItem(Object[] objectArray, int n) {
        for (int i = 0; i < this.title.length; ++i) {
            this.list[i].setElementAt(objectArray[i], n);
        }
        this.repaint();
        this.compscroll();
    }

    Object[] getItem(int n) {
        Object[] objectArray = new Object[this.title.length];
        for (int i = 0; i < this.title.length; ++i) {
            objectArray[i] = this.list[i].elementAt(n);
        }
        return objectArray;
    }

    int selected() {
        return this.sel;
    }

    void select(int n) {
        this.sel = n;
        this.sels = new int[1];
        this.sels[0] = n;
        this.repaint();
    }

    void select(int[] nArray) {
        if (nArray.length == 0) {
            this.sel = -1;
            this.sels = new int[0];
        } else {
            this.sel = nArray[0];
            this.sels = nArray;
        }
        this.repaint();
    }

    int[] allSelected() {
        return this.sels;
    }

    void scrollto(int n) {
        int n2 = this.rows();
        if (n < this.top || n >= this.top + n2) {
            this.top = n - 1;
            if (this.top > this.list[0].size() - n2) {
                this.top = this.list[0].size() - n2;
            }
            this.sb.setValue(this.top);
            this.repaint();
        }
    }

    void deleteItem(int n) {
        int n2;
        for (n2 = 0; n2 < this.title.length; ++n2) {
            this.list[n2].removeElementAt(n);
        }
        if (n == this.sel) {
            this.sel = -1;
        }
        for (n2 = 0; n2 < this.sels.length; ++n2) {
            if (this.sels[n2] != n) continue;
            int[] nArray = new int[this.sels.length - 1];
            if (nArray.length <= 0) break;
            System.arraycopy(this.sels, 0, nArray, 0, n2);
            System.arraycopy(this.sels, n2 + 1, nArray, n2, nArray.length - n2);
            this.sel = nArray[0];
            break;
        }
        this.repaint();
        this.compscroll();
    }

    void clear() {
        for (int i = 0; i < this.title.length; ++i) {
            this.list[i].removeAllElements();
        }
        this.sel = -1;
        this.sels = new int[0];
        this.top = 0;
        this.repaint();
        this.sb.setValues(0, 1, 0);
    }

    void setWidths(float[] fArray) {
        for (int i = 0; i < this.title.length; ++i) {
            this.cwidth[i] = fArray[i];
        }
        this.respace();
        this.repaint();
    }

    void setAdjustable(boolean bl) {
        this.adjustable = bl;
    }

    void setDrawLines(boolean bl) {
        this.drawlines = bl;
    }

    void setColors(Color[][] colorArray) {
        this.colors = colorArray;
        this.repaint();
    }

    void setMultiSelect(boolean bl) {
        this.multiselect = bl;
    }

    public void enable() {
        this.enabled = true;
        this.sb.enable();
        this.repaint();
    }

    public void disable() {
        this.enabled = false;
        this.sb.disable();
        this.repaint();
    }

    public void sortingArrow(int n, int n2) {
        this.sortcol = n;
        this.sortdir = n2;
        this.repaint();
    }

    public void setFont(Font font) {
        this.font = font;
        this.bim = null;
        this.repaint();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 != this.width + this.sbwidth || n4 != this.height) {
            this.in = this.insets();
            this.sbwidth = this.sb.minimumSize().width;
            this.width = n3 - this.sbwidth - (this.in.left + this.in.right);
            this.height = n4 - (this.in.top + this.in.bottom);
            this.sb.reshape(this.width + this.in.left, this.in.top, this.sbwidth, this.height);
            this.respace();
            this.bim = null;
            this.repaint();
            this.compscroll();
        }
        super.reshape(n, n2, n3, n4);
    }

    void respace() {
        this.cpos[0] = 0;
        for (int i = 0; i < this.title.length; ++i) {
            this.cpos[i + 1] = this.cpos[i] + (int)((float)this.width * this.cwidth[i]);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.bim == null) {
            this.bim = this.createImage(this.width, this.height);
            this.bg = this.bim.getGraphics();
            this.bg.setFont(this.font);
            this.fnm = this.bg.getFontMetrics();
            this.th = this.fnm.getHeight() + 4;
            this.render();
            this.compscroll();
        }
        graphics.drawImage(this.bim, this.in.left, this.in.top, this);
    }

    public void update(Graphics graphics) {
        if (this.fnm != null) {
            this.render();
            this.paint(graphics);
        }
    }

    void render() {
        int n;
        int n2 = this.fnm.getHeight();
        int n3 = this.fnm.getDescent();
        int n4 = this.fnm.getAscent();
        int n5 = Math.min(this.top + this.rows() - 1, this.list[0].size() - 1);
        this.bg.setColor(Util.body);
        this.bg.fillRect(0, 0, this.width, this.th);
        this.bg.setColor(Util.light_bg);
        this.bg.fillRect(0, this.th, this.width, this.height - this.th);
        Color color = Util.body_hi;
        if (this.enabled) {
            for (n = 0; n < this.sels.length; ++n) {
                if (this.sels[n] < this.top || this.sels[n] > n5) continue;
                this.bg.setColor(this.sels[n] == this.sel ? Util.body : color);
                this.bg.fillRect(0, this.th + (this.sels[n] - this.top) * this.rowh, this.width, this.rowh);
            }
        }
        for (n = 0; n < this.title.length; ++n) {
            int n6 = this.cpos[n];
            int n7 = this.cpos[n + 1] - n6 - 1;
            this.bg.setColor(Util.light_edge);
            this.bg.drawLine(n6, 0, n6 + n7, 0);
            this.bg.drawLine(n6, 1, n6 + n7 - 1, 1);
            this.bg.drawLine(n6, 0, n6, this.th - 1);
            this.bg.drawLine(n6 + 1, 0, n6 + 1, this.th - 2);
            this.bg.setColor(Util.dark_edge);
            this.bg.drawLine(n6, this.th - 1, n6 + n7, this.th - 1);
            this.bg.drawLine(n6, this.th - 2, n6 + n7 - 1, this.th - 2);
            this.bg.drawLine(n6 + n7, this.th - 1, n6 + n7, 0);
            this.bg.drawLine(n6 + n7 - 1, this.th - 1, n6 + n7 - 1, 1);
            int n8 = this.fnm.stringWidth(this.title[n]);
            if (n8 < n7 - 6) {
                this.bg.drawString(this.title[n], n6 + (n7 - n8) / 2, this.th - n3 - 2);
            }
            int n9 = this.th - 8;
            if (this.sortcol == n && this.sortdir == 1) {
                this.bg.setColor(Util.light_edge);
                this.bg.drawLine(n6 + 4, this.th - 5, n6 + 4 + n9, this.th - 5);
                this.bg.drawLine(n6 + 4 + n9, this.th - 5, n6 + 4 + n9 / 2, this.th - 5 - n9);
                this.bg.setColor(Util.dark_edge);
                this.bg.drawLine(n6 + 4 + n9 / 2, this.th - 5 - n9, n6 + 4, this.th - 5);
            } else if (this.sortcol == n && this.sortdir == 2) {
                this.bg.setColor(Util.light_edge);
                this.bg.drawLine(n6 + 4 + n9 / 2, this.th - 5, n6 + 4 + n9, this.th - 5 - n9);
                this.bg.setColor(Util.dark_edge);
                this.bg.drawLine(n6 + 4, this.th - 5 - n9, n6 + 4 + n9, this.th - 5 - n9);
                this.bg.drawLine(n6 + 4, this.th - 5 - n9, n6 + 4 + n9 / 2, this.th - 5);
            }
            if (this.drawlines) {
                this.bg.setColor(Util.body);
                this.bg.drawLine(n6 + n7 - 1, this.th, n6 + n7 - 1, this.height);
                this.bg.setColor(Util.dark_edge);
                this.bg.drawLine(n6 + n7, this.th, n6 + n7, this.height);
            }
            for (int i = this.top; i <= n5; ++i) {
                Object object;
                Object e = this.list[n].elementAt(i);
                if (e instanceof String) {
                    object = (String)e;
                    while (this.fnm.stringWidth((String)object) > n7 - 3) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    if (!this.enabled) {
                        this.bg.setColor(Util.body);
                    } else if (this.colors != null) {
                        this.bg.setColor(this.colors[i][n]);
                    }
                    this.bg.drawString((String)object, n6 + 1, this.th + (i + 1 - this.top) * this.rowh - n3);
                    continue;
                }
                if (!(e instanceof Image)) continue;
                object = (Image)e;
                this.bg.drawImage((Image)object, n6 + 1, this.th + (i - this.top) * this.rowh, this);
            }
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.enabled) {
            return true;
        }
        n -= this.in.left;
        this.coldrag = -1;
        if ((n2 -= this.in.top) < this.th) {
            for (int i = 0; i < this.title.length; ++i) {
                if (this.adjustable && i > 0 && Math.abs(this.cpos[i] - n) < 3) {
                    this.coldrag = i;
                    continue;
                }
                if (n < this.cpos[i] || n >= this.cpos[i + 1]) continue;
                this.callback.headingClicked(this, i);
            }
        } else {
            int n3 = (n2 - this.th) / this.rowh + this.top;
            if (n3 < this.list[0].size()) {
                boolean bl = false;
                if (event.when - this.last < 1000L && this.sel == n3) {
                    bl = true;
                } else {
                    this.last = event.when;
                }
                if (event.shiftDown() && this.multiselect && this.sel != -1) {
                    int n4 = this.sels[0];
                    if (n4 < n3) {
                        this.sels = new int[n3 - n4 + 1];
                        for (int i = n4; i <= n3; ++i) {
                            this.sels[i - n4] = i;
                        }
                    } else {
                        this.sels = new int[n4 - n3 + 1];
                        for (int i = n4; i >= n3; --i) {
                            this.sels[n4 - i] = i;
                        }
                    }
                } else if (event.controlDown() && this.multiselect) {
                    int[] nArray = new int[this.sels.length + 1];
                    System.arraycopy(this.sels, 0, nArray, 0, this.sels.length);
                    nArray[this.sels.length] = n3;
                    this.sels = nArray;
                } else {
                    this.sels = new int[1];
                    this.sels[0] = n3;
                }
                this.sel = n3;
                this.repaint();
                this.last_event = event;
                if (this.callback != null) {
                    if (bl) {
                        this.callback.doubleClick(this, n3);
                    } else {
                        this.callback.singleClick(this, n3);
                    }
                } else {
                    this.getParent().postEvent(new Event(this, 1001, bl ? "Double" : "Single"));
                }
            }
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (!this.enabled) {
            return true;
        }
        n2 -= this.in.top;
        if (this.coldrag != -1 && (n -= this.in.left) > this.cpos[this.coldrag - 1] + 3 && n < this.cpos[this.coldrag + 1] - 3) {
            this.cpos[this.coldrag] = n;
            this.cwidth[this.coldrag - 1] = (float)(this.cpos[this.coldrag] - this.cpos[this.coldrag - 1]) / (float)this.width;
            this.cwidth[this.coldrag] = (float)(this.cpos[this.coldrag + 1] - this.cpos[this.coldrag]) / (float)this.width;
            this.repaint();
        }
        return true;
    }

    public void moved(CbScrollbar cbScrollbar, int n) {
        this.moving(cbScrollbar, n);
    }

    public void moving(CbScrollbar cbScrollbar, int n) {
        this.top = this.sb.getValue();
        this.compscroll();
        this.repaint();
    }

    private void compscroll() {
        if (this.fnm == null) {
            return;
        }
        int n = this.rows();
        int n2 = this.list[0].size() - n;
        this.sb.setValues(this.top, n == 0 ? 1 : n, this.list[0].size());
    }

    private int rows() {
        return Math.min(this.height / this.rowh - 1, this.list[0].size());
    }

    public Dimension minimumSize() {
        return new Dimension(400, 100);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }
}

