/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ICentralMeridianProvider;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class ObliqueMercator
extends AbstractProj
implements ICentralMeridianProvider {
    private static final double EPSILON = 1.0E-6;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    protected double azimuth;
    protected double rectifiedGridAngle;
    private double B;
    private double A;
    private double E;
    private double ArB;
    private double AB;
    private double BrA;
    private double v_pole_n;
    private double v_pole_s;
    private double singamma0;
    private double cosgamma0;
    private double sinrot;
    private double cosrot;
    private double u_c;
    protected double centralMeridian;
    private LatLon referencePoint;

    @Override
    public String getName() {
        return I18n.tr("Oblique Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "omerc";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        boolean bl;
        double d;
        super.initialize(projParameters);
        boolean bl2 = projParameters.alpha == null;
        double d2 = 0.0;
        if (projParameters.lat0 != null) {
            d2 = Math.toRadians(projParameters.lat0);
        }
        double d3 = Math.sqrt(1.0 - this.e2);
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = 1.0 - this.e2 * d4 * d4;
        double d7 = d5 * d5;
        this.B = Math.sqrt(1.0 + this.e2 * (d7 * d7) / (1.0 - this.e2));
        this.A = this.B * d3 / d6;
        double d8 = this.B * d3 / (d5 * Math.sqrt(d6));
        double d9 = d8 * d8 - 1.0;
        if (d9 < 0.0) {
            d9 = 0.0;
        } else {
            d9 = Math.sqrt(d9);
            if (d2 < 0.0) {
                d9 = -d9;
            }
        }
        this.E = d9 += d8;
        this.E = d9 * Math.pow(this.tsfn(d2, d4), this.B);
        Double d10 = null;
        if (bl2) {
            if (projParameters.lon1 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lon_1"));
            }
            if (projParameters.lat1 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_1"));
            }
            if (projParameters.lon2 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lon_2"));
            }
            if (projParameters.lat2 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_2"));
            }
            this.referencePoint = new LatLon(projParameters.lat1, projParameters.lat2);
            double d11 = Math.toRadians(projParameters.lon1);
            double d12 = Math.toRadians(projParameters.lat1);
            double d13 = Math.toRadians(projParameters.lon2);
            double d14 = Math.toRadians(projParameters.lat2);
            if (Math.abs(d12 - d14) <= 1.0E-6 || Math.abs(d12) <= 1.0E-6 || Math.abs(Math.abs(d12) - 1.5707963267948966) <= 1.0E-6 || Math.abs(Math.abs(d2) - 1.5707963267948966) <= 1.0E-6 || Math.abs(Math.abs(d14) - 1.5707963267948966) <= 1.0E-6) {
                throw new ProjectionConfigurationException(I18n.tr("Unsuitable parameters ''{0}'' and ''{1}'' for two point method.", "lat_1", "lat_2"));
            }
            double d15 = Math.pow(this.tsfn(d12, Math.sin(d12)), this.B);
            double d16 = Math.pow(this.tsfn(d14, Math.sin(d14)), this.B);
            double d17 = this.E / d15;
            double d18 = (d16 - d15) / (d16 + d15);
            double d19 = this.E * this.E;
            d19 = (d19 - d16 * d15) / (d19 + d16 * d15);
            double d20 = d11 - d13;
            if (d20 < -Math.PI) {
                d13 -= Math.PI * 2;
            } else if (d20 > Math.PI) {
                d13 += Math.PI * 2;
            }
            this.centralMeridian = this.normalizeLonRad(0.5 * (d11 + d13) - Math.atan(d19 * Math.tan(0.5 * this.B * (d11 - d13)) / d18) / this.B);
            d = Math.atan(2.0 * Math.sin(this.B * this.normalizeLonRad(d11 - this.centralMeridian)) / (d17 - 1.0 / d17));
            this.rectifiedGridAngle = this.azimuth = Math.asin(d8 * Math.sin(d));
        } else {
            if (projParameters.lonc == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lonc"));
            }
            if (projParameters.lat0 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
            }
            if (projParameters.alpha == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "alpha"));
            }
            this.referencePoint = new LatLon(projParameters.lat0, projParameters.lonc);
            d10 = Math.toRadians(projParameters.lonc);
            this.azimuth = Math.toRadians(projParameters.alpha);
            if (this.azimuth > -4.71238898038469 && this.azimuth < -1.5707963267948966 || this.azimuth > 1.5707963267948966 && this.azimuth < 4.71238898038469) {
                throw new ProjectionConfigurationException(I18n.tr("Illegal value for parameter ''{0}'': {1}", "alpha", Double.toString(projParameters.alpha)));
            }
            this.rectifiedGridAngle = projParameters.gamma != null ? Math.toRadians(projParameters.gamma) : this.azimuth;
            d = Math.asin(Math.sin(this.azimuth) / d8);
            d7 = 0.5 * (d9 - 1.0 / d9) * Math.tan(d);
            if (Math.abs(d7) > 1.0) {
                if (Math.abs(Math.abs(d7) - 1.0) > 1.0E-6) {
                    throw new ProjectionConfigurationException(I18n.tr("error in initialization", new Object[0]));
                }
                d7 = d7 > 0.0 ? 1.0 : -1.0;
            }
            this.centralMeridian = d10 - Math.asin(d7) / this.B;
        }
        this.singamma0 = Math.sin(d);
        this.cosgamma0 = Math.cos(d);
        this.sinrot = Math.sin(this.rectifiedGridAngle);
        this.cosrot = Math.cos(this.rectifiedGridAngle);
        this.ArB = this.A / this.B;
        this.AB = this.A * this.B;
        this.BrA = this.B / this.A;
        this.v_pole_n = this.ArB * Math.log(Math.tan(0.5 * (1.5707963267948966 - d)));
        this.v_pole_s = this.ArB * Math.log(Math.tan(0.5 * (1.5707963267948966 + d)));
        boolean bl3 = bl = projParameters.no_off != null && projParameters.no_off != false;
        if (bl) {
            this.u_c = 0.0;
        } else if (Math.abs(Math.abs(this.azimuth) - 1.5707963267948966) < 1.0E-10) {
            if (d10 == null) {
                throw new ProjectionConfigurationException("assertion error");
            }
            this.u_c = this.A * (d10 - this.centralMeridian);
        } else {
            double d21 = Math.abs(this.ArB * Math.atan2(Math.sqrt(d8 * d8 - 1.0), Math.cos(this.azimuth)));
            if (d2 < 0.0) {
                d21 = -d21;
            }
            this.u_c = d21;
        }
    }

    private double normalizeLonRad(double d) {
        return Math.toRadians(LatLon.normalizeLon(Math.toDegrees(d)));
    }

    @Override
    public double[] project(double d, double d2) {
        double d3;
        double d4;
        if (Math.abs(Math.abs(d) - 1.5707963267948966) > 1.0E-6) {
            double d5;
            double d6;
            double d7 = this.E / Math.pow(this.tsfn(d, Math.sin(d)), this.B);
            double d8 = 0.5 * (d7 - (d6 = 1.0 / d7));
            double d9 = (d8 * this.singamma0 - (d5 = Math.sin(this.B * d2)) * this.cosgamma0) / (0.5 * (d7 + d6));
            d4 = Math.abs(Math.abs(d9) - 1.0) < 1.0E-6 ? 0.0 : 0.5 * this.ArB * Math.log((1.0 - d9) / (1.0 + d9));
            d6 = Math.cos(this.B * d2);
            d3 = Math.abs(d6) < 1.0E-10 ? this.AB * d2 : this.ArB * Math.atan2(d8 * this.cosgamma0 + d5 * this.singamma0, d6);
        } else {
            d4 = d > 0.0 ? this.v_pole_n : this.v_pole_s;
            d3 = this.ArB * d;
        }
        d2 = d4 * this.cosrot + (d3 -= this.u_c) * this.sinrot;
        d = d3 * this.cosrot - d4 * this.sinrot;
        return new double[]{d2, d};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3 = d * this.cosrot - d2 * this.sinrot;
        double d4 = d2 * this.cosrot + d * this.sinrot + this.u_c;
        double d5 = Math.exp(-this.BrA * d3);
        double d6 = 1.0 / d5;
        double d7 = 0.5 * (d5 - d6);
        double d8 = Math.sin(this.BrA * d4);
        double d9 = (d8 * this.cosgamma0 + d7 * this.singamma0) / (0.5 * (d5 + d6));
        if (Math.abs(Math.abs(d9) - 1.0) < 1.0E-6) {
            d = 0.0;
            d2 = d9 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            d2 = Math.pow(this.E / Math.sqrt((1.0 + d9) / (1.0 - d9)), 1.0 / this.B);
            d2 = this.cphi2(d2);
            d = -Math.atan2(d7 * this.cosgamma0 - d8 * this.singamma0, Math.cos(this.BrA * d4)) / this.B;
        }
        return new double[]{d2, d};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        double d = this.referencePoint.lat();
        double d2 = 3.0;
        double d3 = this.referencePoint.lon() - Math.toDegrees(this.centralMeridian);
        double d4 = 3.0;
        return new Bounds(d - d2, d3 - d4, d + d2, d3 + d4, false);
    }

    @Override
    public double getCentralMeridian() {
        return Math.toDegrees(this.centralMeridian);
    }
}

