/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.relation.ChildRelationBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberRoleCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowserModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTable;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddSelectedAfterSelection;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddSelectedAtEndAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddSelectedAtStartAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddSelectedBeforeSelection;
import org.openstreetmap.josm.gui.dialogs.relation.actions.ApplyAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.CancelAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.CopyMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DeleteCurrentRelationAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DownloadIncompleteMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DuplicateRelationAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.EditAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.MoveDownAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.MoveUpAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.OKAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.PasteMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.RefreshAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.RemoveAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.RemoveSelectedAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.ReverseAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SelectPrimitivesForSelectedMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SelectedMembersForSelectionAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SetRoleAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SortAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SortBelowAction;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.WindowGeometry;

public class GenericRelationEditor
extends RelationEditor {
    private final TagEditorPanel tagEditorPanel;
    private final ReferringRelationsBrowser referrerBrowser;
    private final ReferringRelationsBrowserModel referrerModel;
    private MemberTable memberTable;
    private final MemberTableModel memberTableModel;
    private SelectionTable selectionTable;
    private final SelectionTableModel selectionTableModel;
    private AutoCompletingTextField tfRole;
    private JMenuItem windowMenuItem;
    private JButton sortBelowButton;
    private RefreshAction refreshAction;
    private ApplyAction applyAction;
    private CancelAction cancelAction;

    public GenericRelationEditor(OsmDataLayer osmDataLayer, Relation relation, Collection<RelationMember> collection) {
        super(osmDataLayer, relation);
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(700, 650)));
        TaggingPresetHandler taggingPresetHandler = new TaggingPresetHandler(){

            @Override
            public void updateTags(List<Tag> list) {
                GenericRelationEditor.this.tagEditorPanel.getModel().updateTags(list);
            }

            @Override
            public Collection<OsmPrimitive> getSelection() {
                Relation relation = new Relation();
                GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
                return Collections.singletonList(relation);
            }
        };
        this.memberTableModel = new MemberTableModel(relation, this.getLayer(), taggingPresetHandler);
        this.memberTableModel.register();
        this.selectionTableModel = new SelectionTableModel(this.getLayer());
        this.selectionTableModel.register();
        this.referrerModel = new ReferringRelationsBrowserModel(relation);
        this.tagEditorPanel = new TagEditorPanel(relation, taggingPresetHandler);
        this.populateModels(relation);
        this.tagEditorPanel.getModel().ensureOneTag();
        JSplitPane jSplitPane = this.buildSplitPane();
        jSplitPane.setPreferredSize(new Dimension(100, 100));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jSplitPane, "Center");
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(I18n.tr("Tags and Members", new Object[0]), jPanel);
        this.referrerBrowser = new ReferringRelationsBrowser(this.getLayer(), this.referrerModel);
        jTabbedPane.add(I18n.tr("Parent Relations", new Object[0]), this.referrerBrowser);
        jTabbedPane.add(I18n.tr("Child Relations", new Object[0]), new ChildRelationBrowser(this.getLayer(), relation));
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                String string = jTabbedPane.getTitleAt(n = jTabbedPane.getSelectedIndex());
                if (string.equals(I18n.tr("Parent Relations", new Object[0]))) {
                    GenericRelationEditor.this.referrerBrowser.init();
                }
            }
        });
        this.getContentPane().add((Component)this.buildToolBar(), "North");
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.buildOkCancelButtonPanel(), "South");
        this.setSize(this.findMaxDialogSize());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                GenericRelationEditor.this.cleanSelfReferences();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GenericRelationEditor.this.cancel();
            }
        });
        this.registerCopyPasteAction(this.tagEditorPanel.getPasteAction(), "PASTE_TAGS", Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags", new Object[0])), 86, 5009).getKeyStroke());
        this.registerCopyPasteAction(new PasteMembersAction(this.memberTableModel, this.getLayer(), this){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
                GenericRelationEditor.this.tfRole.requestFocusInWindow();
            }
        }, "PASTE_MEMBERS", Shortcut.getPasteKeyStroke());
        this.registerCopyPasteAction(new CopyMembersAction(this.memberTableModel, this.getLayer(), this), "COPY_MEMBERS", Shortcut.getCopyKeyStroke());
        this.tagEditorPanel.setNextFocusComponent(this.memberTable);
        this.selectionTable.setFocusable(false);
        this.memberTableModel.setSelectedMembers(collection);
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/RelationEditor"));
    }

    @Override
    public void reloadDataFromRelation() {
        this.setRelation(this.getRelation());
        this.populateModels(this.getRelation());
        this.refreshAction.updateEnabledState();
    }

    private void populateModels(Relation relation) {
        if (relation != null) {
            this.tagEditorPanel.getModel().initFromPrimitive(relation);
            this.memberTableModel.populate(relation);
            if (!this.getLayer().data.getRelations().contains(relation)) {
                this.setRelation(null);
            }
        } else {
            this.tagEditorPanel.getModel().clear();
            this.memberTableModel.populate(null);
        }
    }

    public void apply() {
        this.applyAction.actionPerformed(null);
    }

    public void cancel() {
        this.cancelAction.actionPerformed(null);
    }

    protected JToolBar buildToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.refreshAction = new RefreshAction(this.memberTable, this.memberTableModel, this.tagEditorPanel.getModel(), this.getLayer(), (IRelationEditor)this);
        this.applyAction = new ApplyAction(this.memberTable, this.memberTableModel, this.tagEditorPanel.getModel(), this.getLayer(), (IRelationEditor)this);
        jToolBar.add(this.refreshAction);
        jToolBar.add(this.applyAction);
        jToolBar.add(new DuplicateRelationAction(this.memberTableModel, this.tagEditorPanel.getModel(), this.getLayer()));
        DeleteCurrentRelationAction deleteCurrentRelationAction = new DeleteCurrentRelationAction(this.getLayer(), this);
        this.addPropertyChangeListener(deleteCurrentRelationAction);
        jToolBar.add(deleteCurrentRelationAction);
        return jToolBar;
    }

    protected JPanel buildOkCancelButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(new SideButton(new OKAction(this.memberTable, this.memberTableModel, this.tagEditorPanel.getModel(), this.getLayer(), this, this.tfRole)));
        this.cancelAction = new CancelAction(this.memberTable, this.memberTableModel, this.tagEditorPanel.getModel(), this.getLayer(), this, this.tfRole);
        jPanel.add(new SideButton(this.cancelAction));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/RelationEditor"))));
        return jPanel;
    }

    protected JPanel buildTagEditorPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Tags", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.tagEditorPanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildMemberEditorPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.memberTable = new MemberTable(this.getLayer(), this.getRelation(), this.memberTableModel);
        this.memberTable.addMouseListener(new MemberTableDblClickAdapter());
        this.memberTableModel.addMemberModelListener(this.memberTable);
        JScrollPane jScrollPane = new JScrollPane(this.memberTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Members", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.buildLeftButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(I18n.tr("Apply Role:", new Object[0])));
        this.tfRole = new AutoCompletingTextField(10);
        this.tfRole.setToolTipText(I18n.tr("Enter a role and apply it to the selected relation members", new Object[0]));
        this.tfRole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                GenericRelationEditor.this.tfRole.selectAll();
            }
        });
        this.tfRole.setAutoCompletionList(new AutoCompletionList());
        this.tfRole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AutoCompletionList autoCompletionList = GenericRelationEditor.this.tfRole.getAutoCompletionList();
                if (autoCompletionList != null) {
                    autoCompletionList.clear();
                    GenericRelationEditor.this.getLayer().data.getAutoCompletionManager().populateWithMemberRoles(autoCompletionList, GenericRelationEditor.this.getRelation());
                }
            }
        });
        this.tfRole.setText(Main.pref.get("relation.editor.generic.lastrole", ""));
        jPanel2.add(this.tfRole);
        SetRoleAction setRoleAction = new SetRoleAction(this.memberTable, this.memberTableModel, this.tfRole);
        this.memberTableModel.getSelectionModel().addListSelectionListener(setRoleAction);
        this.tfRole.getDocument().addDocumentListener(setRoleAction);
        this.tfRole.addActionListener(setRoleAction);
        this.memberTableModel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GenericRelationEditor.this.tfRole.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
            }
        });
        this.tfRole.setEnabled(this.memberTable.getSelectedRowCount() > 0);
        SideButton sideButton = new SideButton(setRoleAction);
        sideButton.setPreferredSize(new Dimension(20, 20));
        sideButton.setText("");
        jPanel2.add(sideButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel3.add((Component)new JLabel(I18n.tr("Selection", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.buildSelectionControlButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)this.buildSelectionTablePanel(), gridBagConstraints);
        final JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jPanel);
        jSplitPane.setRightComponent(jPanel3);
        jSplitPane.setOneTouchExpandable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                jSplitPane.setDividerLocation(0.6);
            }
        });
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jSplitPane, "Center");
        return jPanel4;
    }

    protected JPanel buildSelectionTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        MemberRoleCellEditor memberRoleCellEditor = (MemberRoleCellEditor)this.memberTable.getColumnModel().getColumn(0).getCellEditor();
        this.selectionTable = new SelectionTable(this.selectionTableModel, new SelectionTableColumnModel(this.memberTableModel));
        this.selectionTable.setMemberTableModel(this.memberTableModel);
        this.selectionTable.setRowHeight(memberRoleCellEditor.getEditor().getPreferredSize().height);
        jPanel.add((Component)new JScrollPane(this.selectionTable), "Center");
        return jPanel;
    }

    protected JSplitPane buildSplitPane() {
        final JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(this.buildTagEditorPanel());
        jSplitPane.setBottomComponent(this.buildMemberEditorPanel());
        jSplitPane.setOneTouchExpandable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                jSplitPane.setDividerLocation(0.3);
            }
        });
        return jSplitPane;
    }

    protected JToolBar buildLeftButtonPanel() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOrientation(1);
        jToolBar.setFloatable(false);
        MoveUpAction moveUpAction = new MoveUpAction(this.memberTable, this.memberTableModel, "moveUp");
        this.memberTableModel.getSelectionModel().addListSelectionListener(moveUpAction);
        jToolBar.add(moveUpAction);
        MoveDownAction moveDownAction = new MoveDownAction(this.memberTable, this.memberTableModel, "moveDown");
        this.memberTableModel.getSelectionModel().addListSelectionListener(moveDownAction);
        jToolBar.add(moveDownAction);
        jToolBar.addSeparator();
        EditAction editAction = new EditAction(this.memberTable, this.memberTableModel, this.getLayer());
        this.memberTableModel.getSelectionModel().addListSelectionListener(editAction);
        jToolBar.add(editAction);
        RemoveAction removeAction = new RemoveAction(this.memberTable, this.memberTableModel, "removeSelected");
        this.memberTable.getSelectionModel().addListSelectionListener(removeAction);
        jToolBar.add(removeAction);
        jToolBar.addSeparator();
        SortAction sortAction = new SortAction(this.memberTable, this.memberTableModel);
        this.memberTableModel.addTableModelListener(sortAction);
        jToolBar.add(sortAction);
        SortBelowAction sortBelowAction = new SortBelowAction(this.memberTable, this.memberTableModel);
        this.memberTableModel.addTableModelListener(sortBelowAction);
        this.memberTableModel.getSelectionModel().addListSelectionListener(sortBelowAction);
        this.sortBelowButton = jToolBar.add(sortBelowAction);
        ReverseAction reverseAction = new ReverseAction(this.memberTable, this.memberTableModel);
        this.memberTableModel.addTableModelListener(reverseAction);
        jToolBar.add(reverseAction);
        jToolBar.addSeparator();
        DownloadIncompleteMembersAction downloadIncompleteMembersAction = new DownloadIncompleteMembersAction(this.memberTable, this.memberTableModel, "downloadIncomplete", this.getLayer(), this);
        this.memberTable.getModel().addTableModelListener(downloadIncompleteMembersAction);
        jToolBar.add(downloadIncompleteMembersAction);
        DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction(this.memberTable, this.memberTableModel, null, this.getLayer(), this);
        this.memberTable.getModel().addTableModelListener(downloadSelectedIncompleteMembersAction);
        this.memberTable.getSelectionModel().addListSelectionListener(downloadSelectedIncompleteMembersAction);
        jToolBar.add(downloadSelectedIncompleteMembersAction);
        InputMap inputMap = this.memberTable.getInputMap(1);
        inputMap.put((KeyStroke)removeAction.getValue("AcceleratorKey"), "removeSelected");
        inputMap.put((KeyStroke)moveUpAction.getValue("AcceleratorKey"), "moveUp");
        inputMap.put((KeyStroke)moveDownAction.getValue("AcceleratorKey"), "moveDown");
        inputMap.put((KeyStroke)downloadIncompleteMembersAction.getValue("AcceleratorKey"), "downloadIncomplete");
        return jToolBar;
    }

    protected JToolBar buildSelectionControlButtonPanel() {
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        AddSelectedAtStartAction addSelectedAtStartAction = new AddSelectedAtStartAction(this.memberTableModel, this.selectionTableModel, this);
        this.selectionTableModel.addTableModelListener(addSelectedAtStartAction);
        jToolBar.add(addSelectedAtStartAction);
        AddSelectedBeforeSelection addSelectedBeforeSelection = new AddSelectedBeforeSelection(this.memberTableModel, this.selectionTableModel, this);
        this.selectionTableModel.addTableModelListener(addSelectedBeforeSelection);
        this.memberTableModel.getSelectionModel().addListSelectionListener(addSelectedBeforeSelection);
        jToolBar.add(addSelectedBeforeSelection);
        AddSelectedAfterSelection addSelectedAfterSelection = new AddSelectedAfterSelection(this.memberTableModel, this.selectionTableModel, this);
        this.selectionTableModel.addTableModelListener(addSelectedAfterSelection);
        this.memberTableModel.getSelectionModel().addListSelectionListener(addSelectedAfterSelection);
        jToolBar.add(addSelectedAfterSelection);
        AddSelectedAtEndAction addSelectedAtEndAction = new AddSelectedAtEndAction(this.memberTableModel, this.selectionTableModel, this);
        this.selectionTableModel.addTableModelListener(addSelectedAtEndAction);
        jToolBar.add(addSelectedAtEndAction);
        jToolBar.addSeparator();
        SelectedMembersForSelectionAction selectedMembersForSelectionAction = new SelectedMembersForSelectionAction(this.memberTableModel, this.selectionTableModel, this.getLayer());
        this.selectionTableModel.addTableModelListener(selectedMembersForSelectionAction);
        this.memberTableModel.addTableModelListener(selectedMembersForSelectionAction);
        jToolBar.add(selectedMembersForSelectionAction);
        SelectPrimitivesForSelectedMembersAction selectPrimitivesForSelectedMembersAction = new SelectPrimitivesForSelectedMembersAction(this.memberTable, this.memberTableModel, this.getLayer());
        this.memberTable.getSelectionModel().addListSelectionListener(selectPrimitivesForSelectedMembersAction);
        jToolBar.add(selectPrimitivesForSelectedMembersAction);
        jToolBar.addSeparator();
        RemoveSelectedAction removeSelectedAction = new RemoveSelectedAction(this.memberTableModel, this.selectionTableModel, this.getLayer());
        this.selectionTableModel.addTableModelListener(removeSelectedAction);
        jToolBar.add(removeSelectedAction);
        return jToolBar;
    }

    @Override
    protected Dimension findMaxDialogSize() {
        return new Dimension(700, 650);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.tagEditorPanel.initAutoCompletion(this.getLayer());
        }
        super.setVisible(bl);
        if (bl) {
            this.sortBelowButton.setVisible(ExpertToggleAction.isExpert());
            RelationDialogManager.getRelationDialogManager().positionOnScreen(this);
            if (this.windowMenuItem == null) {
                this.addToWindowMenu();
            }
            this.tagEditorPanel.requestFocusInWindow();
        } else {
            this.memberTable.stopHighlighting();
            this.selectionTableModel.unregister();
            this.memberTableModel.unregister();
            this.memberTable.unlinkAsListener();
            if (this.windowMenuItem != null) {
                Main.main.menu.windowMenu.remove(this.windowMenuItem);
                this.windowMenuItem = null;
            }
            this.dispose();
        }
    }

    protected void addToWindowMenu() {
        String string = this.getRelation() == null ? I18n.tr("New Relation", new Object[0]) : this.getRelation().getLocalName();
        String string2 = I18n.tr("Focus Relation Editor with relation ''{0}'' in layer ''{1}''", string, this.getLayer().getName());
        string = I18n.tr("Relation Editor: {0}", string == null ? Long.valueOf(this.getRelation().getId()) : string);
        JMenu jMenu = Main.main.menu.windowMenu;
        JosmAction josmAction = new JosmAction(string, "dialogs/relationlist", string2, null, false, false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RelationEditor relationEditor = (RelationEditor)this.getValue("relationEditor");
                relationEditor.setVisible(true);
            }
        };
        josmAction.putValue("relationEditor", this);
        this.windowMenuItem = MainMenu.add(jMenu, josmAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
    }

    protected void cleanSelfReferences() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        arrayList.add(this.getRelation());
        if (this.memberTableModel.hasMembersReferringTo(arrayList)) {
            int n = ConditionalOptionPaneUtil.showOptionDialog("clean_relation_self_references", Main.parent, I18n.tr("<html>There is at least one member in this relation referring<br>to the relation itself.<br>This creates circular dependencies and is discouraged.<br>How do you want to proceed with circular dependencies?</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 0, 2, new String[]{I18n.tr("Remove them, clean up relation", new Object[0]), I18n.tr("Ignore them, leave relation as is", new Object[0])}, I18n.tr("Remove them, clean up relation", new Object[0]));
            switch (n) {
                case -2147483648: 
                case -1: 
                case 1: {
                    return;
                }
                case 0: {
                    this.memberTableModel.removeMembersReferringTo(arrayList);
                }
            }
        }
    }

    private void registerCopyPasteAction(AbstractAction abstractAction, Object object, KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        int n2 = keyStroke.getKeyCode();
        if (n2 != 155 && (n == 0 || n == 64)) {
            Main.info(I18n.tr("Sorry, shortcut \"{0}\" can not be enabled in Relation editor dialog", new Object[0]), keyStroke);
            return;
        }
        this.getRootPane().getActionMap().put(object, abstractAction);
        this.getRootPane().getInputMap(2).put(keyStroke, object);
        this.memberTable.getInputMap(0).put(keyStroke, object);
        this.memberTable.getInputMap(1).put(keyStroke, object);
        this.memberTable.getInputMap(2).put(keyStroke, object);
        this.selectionTable.getInputMap(0).put(keyStroke, object);
        this.selectionTable.getInputMap(1).put(keyStroke, object);
        this.selectionTable.getInputMap(2).put(keyStroke, object);
    }

    public static boolean confirmAddingPrimitive(OsmPrimitive osmPrimitive) throws AddAbortException {
        String string = I18n.tr("<html>This relation already has one or more members referring to<br>the object ''{0}''<br><br>Do you really want to add another relation member?</html>", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
        int n = ConditionalOptionPaneUtil.showOptionDialog("add_primitive_to_relation", Main.parent, string, I18n.tr("Multiple members referring to same object.", new Object[0]), 1, 2, null, null);
        switch (n) {
            case -2147483648: 
            case 0: {
                return true;
            }
            case -1: 
            case 1: {
                return false;
            }
        }
        throw new AddAbortException();
    }

    public static void warnOfCircularReferences(OsmPrimitive osmPrimitive) {
        String string = I18n.tr("<html>You are trying to add a relation to itself.<br><br>This creates circular references and is therefore discouraged.<br>Skipping relation ''{0}''.</html>", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2);
    }

    public static Command addPrimitivesToRelation(Relation relation, Collection<? extends OsmPrimitive> collection) {
        CheckParameterUtil.ensureParameterNotNull(relation, "orig");
        try {
            Collection<TaggingPreset> collection2 = TaggingPresets.getMatchingPresets(EnumSet.of(TaggingPresetType.forPrimitive(relation)), relation.getKeys(), false);
            Relation relation2 = new Relation(relation);
            boolean bl = false;
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive instanceof Relation && relation.equals(osmPrimitive)) {
                    if (GraphicsEnvironment.isHeadless()) continue;
                    GenericRelationEditor.warnOfCircularReferences(osmPrimitive);
                    continue;
                }
                if (MemberTableModel.hasMembersReferringTo(relation2.getMembers(), Collections.singleton(osmPrimitive)) && !GenericRelationEditor.confirmAddingPrimitive(osmPrimitive)) continue;
                Set<String> set = GenericRelationEditor.findSuggestedRoles(collection2, osmPrimitive);
                relation2.addMember(new RelationMember(set.size() == 1 ? set.iterator().next() : "", osmPrimitive));
                bl = true;
            }
            return bl ? new ChangeCommand(relation, relation2) : null;
        }
        catch (AddAbortException addAbortException) {
            return null;
        }
    }

    protected static Set<String> findSuggestedRoles(Collection<TaggingPreset> collection, OsmPrimitive osmPrimitive) {
        HashSet<String> hashSet = new HashSet<String>();
        for (TaggingPreset taggingPreset : collection) {
            String string = taggingPreset.suggestRoleForOsmPrimitive(osmPrimitive);
            if (string == null || string.isEmpty()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    class MemberTableDblClickAdapter
    extends MouseAdapter {
        MemberTableDblClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                new EditAction(GenericRelationEditor.this.memberTable, GenericRelationEditor.this.memberTableModel, GenericRelationEditor.this.getLayer()).actionPerformed(null);
            }
        }
    }

    public static class AddAbortException
    extends Exception {
    }
}

