/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.actions.search.SearchCompiler;

public final class CompileSearchTextDecorator
implements DocumentListener {
    private final JTextComponent textComponent;
    private final String originalToolTipText;
    private SearchCompiler.Match filter = null;

    private CompileSearchTextDecorator(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.originalToolTipText = jTextComponent.getToolTipText();
        jTextComponent.getDocument().addDocumentListener(this);
    }

    public static CompileSearchTextDecorator decorate(JTextComponent jTextComponent) {
        return new CompileSearchTextDecorator(jTextComponent);
    }

    private void setFilter() {
        try {
            this.textComponent.setBackground(UIManager.getColor("TextField.background"));
            this.textComponent.setToolTipText(this.originalToolTipText);
            this.filter = SearchCompiler.compile(this.textComponent.getText());
        }
        catch (SearchCompiler.ParseError parseError) {
            this.textComponent.setBackground(new Color(255, 224, 224));
            this.textComponent.setToolTipText(parseError.getMessage());
            this.filter = new SearchCompiler.Always();
        }
        this.textComponent.firePropertyChange("filter", 0, 1);
    }

    public SearchCompiler.Match getMatch() {
        return this.filter;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setFilter();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setFilter();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setFilter();
    }
}

