/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="requiredCapacity", type=RubyNode.class)})
public abstract class ArrayEnsureCapacityNode
extends RubyNode {
    private final ConditionProfile allocateProfile = ConditionProfile.createCountingProfile();

    public ArrayEnsureCapacityNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeEnsureCapacity(DynamicObject var1, int var2);

    @Specialization(guards={"isIntArray(array)"})
    public boolean ensureCapacityInt(DynamicObject array, int requiredCapacity) {
        int[] store = (int[])Layouts.ARRAY.getStore(array);
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            Layouts.ARRAY.setStore(array, Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
            return true;
        }
        return false;
    }

    @Specialization(guards={"isLongArray(array)"})
    public boolean ensureCapacityLong(DynamicObject array, int requiredCapacity) {
        long[] store = (long[])Layouts.ARRAY.getStore(array);
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            Layouts.ARRAY.setStore(array, Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
            return true;
        }
        return false;
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public boolean ensureCapacityDouble(DynamicObject array, int requiredCapacity) {
        double[] store = (double[])Layouts.ARRAY.getStore(array);
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            Layouts.ARRAY.setStore(array, Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
            return true;
        }
        return false;
    }

    @Specialization(guards={"isObjectArray(array)"})
    public boolean ensureCapacityObject(DynamicObject array, int requiredCapacity) {
        Object[] store = (Object[])Layouts.ARRAY.getStore(array);
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            Layouts.ARRAY.setStore(array, ArrayUtils.grow(store, ArrayUtils.capacity(store.length, requiredCapacity)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
            return true;
        }
        return false;
    }
}

