/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringMatcher;

public class MemberNameFilter
implements MemberVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final MemberVisitor memberVisitor;

    public MemberNameFilter(String string, MemberVisitor memberVisitor) {
        this(new ListParser(new NameParser()).parse(string), memberVisitor);
    }

    public MemberNameFilter(StringMatcher stringMatcher, MemberVisitor memberVisitor) {
        this.regularExpressionMatcher = stringMatcher;
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.accepted(programField.getName(programClass))) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.accepted(programMethod.getName(programClass))) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.accepted(libraryField.getName(libraryClass))) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.accepted(libraryMethod.getName(libraryClass))) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private boolean accepted(String string) {
        return this.regularExpressionMatcher.matches(string);
    }
}

