/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sa;

import com.sun.tools.visualvm.sa.SAObject;
import com.sun.tools.visualvm.sa.VM;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class StackTrace {
    private VM vm;
    private SAObject heap;
    private SAObject objectClass;

    StackTrace(VM v) throws IllegalAccessException, InvocationTargetException {
        this.vm = v;
        this.heap = this.vm.getObjectHeap();
        this.objectClass = this.vm.getSystemDictionary().invokeSA("getObjectKlass", new Object[0]);
    }

    public String getStackTrace() throws IllegalAccessException, InvocationTargetException {
        ByteArrayOutputStream data = new ByteArrayOutputStream(4096);
        PrintStream out = new PrintStream(data);
        SAObject threads = this.vm.getThreads();
        SAObject curThread = threads.invokeSA("first", new Object[0]);
        while (!curThread.isNull()) {
            try {
                Boolean isJavaThread = (Boolean)curThread.invoke("isJavaThread", new Object[0]);
                if (!isJavaThread.booleanValue()) {
                    out.print("VM ");
                }
                out.print("Thread ");
                curThread.invoke("printThreadIDOn", out);
                out.print(" \"" + curThread.invoke("getThreadName", new Object[0]) + "\"");
                out.print(": (state = ");
                out.print(curThread.invoke("getThreadState", new Object[0]));
                out.println(")");
                if (isJavaThread.booleanValue()) {
                    SAObject javaFrame = curThread.invokeSA("getLastJavaVFrameDbg", new Object[0]);
                    Object waitingToLockMonitor = curThread.invoke("getCurrentPendingMonitor", new Object[0]);
                    boolean objectWaitFrame = this.isJavaLangObjectWaitFrame(javaFrame);
                    while (!javaFrame.isNull()) {
                        this.printJavaFrame(out, javaFrame);
                        this.printMonitors(out, javaFrame, waitingToLockMonitor, objectWaitFrame);
                        waitingToLockMonitor = null;
                        objectWaitFrame = false;
                        javaFrame = javaFrame.invokeSA("javaSender", new Object[0]);
                    }
                }
            }
            catch (Exception ex) {
                out.println("\t-- Error occurred during stack walking");
                Logger.getLogger(StackTrace.class.getName()).log(Level.INFO, "getStackTrace", ex);
            }
            out.println();
            curThread = curThread.invokeSA("next", new Object[0]);
        }
        return data.toString();
    }

    private boolean isJavaLangObjectWaitFrame(SAObject javaFrame) throws IllegalAccessException, InvocationTargetException {
        if (!javaFrame.isNull()) {
            SAObject method = javaFrame.invokeSA("getMethod", new Object[0]);
            SAObject klass = method.invokeSA("getMethodHolder", new Object[0]);
            Boolean isNative = (Boolean)method.invoke("isNative", new Object[0]);
            if (this.objectClass.equals(klass) && isNative.booleanValue() && "wait".equals(method.invokeSA("getName", new Object[0]).invoke("asString", new Object[0]))) {
                return true;
            }
        }
        return false;
    }

    private void printMonitors(PrintStream out, SAObject javaFrame, Object waitingToLockMonitor, boolean objectWaitFrame) throws IllegalAccessException, InvocationTargetException {
        SAObject stackValueCollection;
        Boolean isEmpty;
        if (objectWaitFrame && !(isEmpty = (Boolean)(stackValueCollection = javaFrame.invokeSA("getLocals", new Object[0])).invoke("isEmpty", new Object[0])).booleanValue()) {
            Object oopHandle = stackValueCollection.invoke("oopHandleAt", 0);
            this.printMonitor(out, oopHandle, "waiting on");
        }
        try {
            List mList = (List)javaFrame.invoke("getMonitors", new Object[0]);
            Object[] monitors = mList.toArray();
            for (int i = monitors.length - 1; i >= 0; --i) {
                Object objectHandle;
                SAObject monitorInfo = new SAObject(monitors[i]);
                Object ownerHandle = monitorInfo.invoke("owner", new Object[0]);
                if (ownerHandle == null) continue;
                String state = "locked";
                if (waitingToLockMonitor != null && (objectHandle = new SAObject(waitingToLockMonitor).invoke("object", new Object[0])).equals(ownerHandle)) {
                    state = "waiting to lock";
                }
                this.printMonitor(out, ownerHandle, state);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void printMonitor(PrintStream out, Object ownerHandle, String state) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\t- " + state + " <" + ownerHandle + "> ");
            this.printOop(sb, ownerHandle);
            out.println(sb.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void printOop(StringBuilder sb, Object oopHandle) throws IllegalAccessException, InvocationTargetException {
        SAObject oop = this.heap.invokeSA("newOop", oopHandle);
        if (!oop.isNull()) {
            sb.append("(a ");
            String monitorClassName = (String)oop.invokeSA("getKlass", new Object[0]).invokeSA("getName", new Object[0]).invoke("asString", new Object[0]);
            sb.append(monitorClassName.replace('/', '.'));
            sb.append(")");
        } else {
            sb.append("(Raw Monitor)");
        }
    }

    private void printJavaFrame(PrintStream out, SAObject javaFrame) throws IllegalAccessException, InvocationTargetException {
        SAObject method = javaFrame.invokeSA("getMethod", new Object[0]);
        out.print("\tat ");
        SAObject klass = method.invokeSA("getMethodHolder", new Object[0]);
        String className = (String)klass.invokeSA("getName", new Object[0]).invoke("asString", new Object[0]);
        out.print(className.replace('/', '.'));
        out.print(".");
        out.print(method.invokeSA("getName", new Object[0]).invoke("asString", new Object[0]));
        Integer bci = (Integer)javaFrame.invoke("getBCI", new Object[0]);
        out.print("(");
        if (((Boolean)method.invoke("isNative", new Object[0])).booleanValue()) {
            out.print("Native Method");
        } else {
            Integer lineNumber = (Integer)method.invoke("getLineNumberFromBCI", bci);
            SAObject sourceName = klass.invokeSA("getSourceFileName", new Object[0]);
            if (lineNumber != -1 && !sourceName.isNull()) {
                out.print(sourceName.invoke("asString", new Object[0]));
                out.print(":");
                out.print(lineNumber);
            } else {
                out.print("bci=");
                out.print(bci);
            }
        }
        out.println(")");
    }
}

