/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class AndTerm
extends SearchTerm {
    protected SearchTerm[] terms;

    public AndTerm(SearchTerm t1, SearchTerm t2) {
        this.terms = new SearchTerm[2];
        this.terms[0] = t1;
        this.terms[1] = t2;
    }

    public AndTerm(SearchTerm[] t) {
        this.terms = new SearchTerm[t.length];
        System.arraycopy(t, 0, this.terms, 0, t.length);
    }

    public SearchTerm[] getTerms() {
        return (SearchTerm[])this.terms.clone();
    }

    @Override
    public boolean match(Message message) {
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].match(message)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof AndTerm) {
            AndTerm andterm = (AndTerm)other;
            if (andterm.terms.length != this.terms.length) {
                return false;
            }
            for (int i = 0; i < this.terms.length; ++i) {
                if (this.terms[i].equals(andterm.terms[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int acc = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            acc += this.terms[i].hashCode();
        }
        return acc;
    }
}

