/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.NameNode;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import java.lang.ref.SoftReference;
import java.util.Date;

class ZoneNode
extends NameNode {
    private SoftReference contentsRef = null;
    private long serialNumber = -1L;
    private Date expiration = null;

    ZoneNode(String label) {
        super(label);
    }

    @Override
    protected NameNode newNameNode(String label) {
        return new ZoneNode(label);
    }

    synchronized void depopulate() {
        this.contentsRef = null;
        this.serialNumber = -1L;
    }

    synchronized boolean isPopulated() {
        return this.getContents() != null;
    }

    synchronized NameNode getContents() {
        return this.contentsRef != null ? (NameNode)this.contentsRef.get() : null;
    }

    synchronized boolean isExpired() {
        return this.expiration != null && this.expiration.before(new Date());
    }

    ZoneNode getDeepestPopulated(DnsName fqdn) {
        ZoneNode znode = this;
        ZoneNode popNode = this.isPopulated() ? this : null;
        for (int i = 1; i < fqdn.size() && (znode = (ZoneNode)znode.get(fqdn.getKey(i))) != null; ++i) {
            if (!znode.isPopulated()) continue;
            popNode = znode;
        }
        return popNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NameNode populate(DnsName zone, ResourceRecords rrs) {
        NameNode newContents = new NameNode(null);
        for (int i = 0; i < rrs.answer.size(); ++i) {
            ResourceRecord rr = (ResourceRecord)rrs.answer.elementAt(i);
            DnsName n = rr.getName();
            if (n.size() <= zone.size() || !n.startsWith(zone)) continue;
            NameNode nnode = newContents.add(n, zone.size());
            if (rr.getType() != 2) continue;
            nnode.setZoneCut(true);
        }
        ResourceRecord soa = (ResourceRecord)rrs.answer.firstElement();
        ZoneNode zoneNode = this;
        synchronized (zoneNode) {
            this.contentsRef = new SoftReference<NameNode>(newContents);
            this.serialNumber = ZoneNode.getSerialNumber(soa);
            this.setExpiration(ZoneNode.getMinimumTtl(soa));
            return newContents;
        }
    }

    private void setExpiration(long secsToExpiration) {
        this.expiration = new Date(System.currentTimeMillis() + 1000L * secsToExpiration);
    }

    private static long getMinimumTtl(ResourceRecord soa) {
        String rdata = (String)soa.getRdata();
        int pos = rdata.lastIndexOf(32) + 1;
        return Long.parseLong(rdata.substring(pos));
    }

    int compareSerialNumberTo(ResourceRecord soa) {
        return ResourceRecord.compareSerialNumbers(this.serialNumber, ZoneNode.getSerialNumber(soa));
    }

    private static long getSerialNumber(ResourceRecord soa) {
        String rdata = (String)soa.getRdata();
        int beg = rdata.length();
        int end = -1;
        for (int i = 0; i < 5; ++i) {
            end = beg;
            beg = rdata.lastIndexOf(32, end - 1);
        }
        return Long.parseLong(rdata.substring(beg + 1, end));
    }
}

