/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameImpl;

public class CompoundName
implements Name {
    protected transient NameImpl impl;
    protected transient Properties mySyntax;
    private static final long serialVersionUID = 3513100557083972036L;

    protected CompoundName(Enumeration<String> comps, Properties syntax) {
        if (syntax == null) {
            throw new NullPointerException();
        }
        this.mySyntax = syntax;
        this.impl = new NameImpl(syntax, comps);
    }

    public CompoundName(String n, Properties syntax) throws InvalidNameException {
        if (syntax == null) {
            throw new NullPointerException();
        }
        this.mySyntax = syntax;
        this.impl = new NameImpl(syntax, n);
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof CompoundName && this.impl.equals(((CompoundName)obj).impl);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    @Override
    public Object clone() {
        return new CompoundName(this.getAll(), this.mySyntax);
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof CompoundName)) {
            throw new ClassCastException("Not a CompoundName");
        }
        return this.impl.compareTo(((CompoundName)obj).impl);
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        return this.impl.getAll();
    }

    @Override
    public String get(int posn) {
        return this.impl.get(posn);
    }

    @Override
    public Name getPrefix(int posn) {
        Enumeration comps = this.impl.getPrefix(posn);
        return new CompoundName(comps, this.mySyntax);
    }

    @Override
    public Name getSuffix(int posn) {
        Enumeration comps = this.impl.getSuffix(posn);
        return new CompoundName(comps, this.mySyntax);
    }

    @Override
    public boolean startsWith(Name n) {
        if (n instanceof CompoundName) {
            return this.impl.startsWith(n.size(), n.getAll());
        }
        return false;
    }

    @Override
    public boolean endsWith(Name n) {
        if (n instanceof CompoundName) {
            return this.impl.endsWith(n.size(), n.getAll());
        }
        return false;
    }

    @Override
    public Name addAll(Name suffix) throws InvalidNameException {
        if (suffix instanceof CompoundName) {
            this.impl.addAll(suffix.getAll());
            return this;
        }
        throw new InvalidNameException("Not a compound name: " + suffix.toString());
    }

    @Override
    public Name addAll(int posn, Name n) throws InvalidNameException {
        if (n instanceof CompoundName) {
            this.impl.addAll(posn, n.getAll());
            return this;
        }
        throw new InvalidNameException("Not a compound name: " + n.toString());
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        this.impl.add(comp);
        return this;
    }

    @Override
    public Name add(int posn, String comp) throws InvalidNameException {
        this.impl.add(posn, comp);
        return this;
    }

    @Override
    public Object remove(int posn) throws InvalidNameException {
        return this.impl.remove(posn);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.mySyntax);
        s.writeInt(this.size());
        Enumeration<String> comps = this.getAll();
        while (comps.hasMoreElements()) {
            s.writeObject(comps.nextElement());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.mySyntax = (Properties)s.readObject();
        this.impl = new NameImpl(this.mySyntax);
        int n = s.readInt();
        try {
            while (--n >= 0) {
                this.add((String)s.readObject());
            }
        }
        catch (InvalidNameException e) {
            throw new StreamCorruptedException("Invalid name");
        }
    }
}

