/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.netbeans.modules.profiler.heapwalk.InstancesController;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.OQLController;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.ui.HeapFragmentWalkerUI;
import org.openide.util.Lookup;

public class HeapFragmentWalker {
    public static final int RETAINED_SIZES_UNSUPPORTED = -1;
    public static final int RETAINED_SIZES_UNKNOWN = 0;
    public static final int RETAINED_SIZES_CANCELLED = 1;
    public static final int RETAINED_SIZES_COMPUTING = 2;
    public static final int RETAINED_SIZES_COMPUTED = 3;
    private AnalysisController analysisController;
    private OQLController oqlController;
    private ClassesController classesController;
    private Heap heapFragment;
    private HeapFragmentWalkerUI walkerUI;
    private HeapWalker heapWalker;
    private InstancesController instancesController;
    private NavigationHistoryManager navigationHistoryManager;
    private SummaryController summaryController;
    private List<StateListener> stateListeners;
    private int retainedSizesStatus;

    public HeapFragmentWalker(Heap heap, HeapWalker heapWalker) {
        this(heap, heapWalker, false);
    }

    public HeapFragmentWalker(Heap heap, HeapWalker heapWalker, boolean bl) {
        this.heapFragment = heap;
        this.heapWalker = heapWalker;
        this.retainedSizesStatus = bl ? 0 : -1;
        this.summaryController = new SummaryController(this);
        this.classesController = new ClassesController(this);
        this.instancesController = new InstancesController(this);
        this.analysisController = new AnalysisController(this);
        this.navigationHistoryManager = new NavigationHistoryManager(this);
        this.oqlController = new OQLController(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int computeRetainedSizes(boolean bl, boolean bl2) {
        Object object = this;
        synchronized (object) {
            if (this.retainedSizesStatus == -1 || this.retainedSizesStatus == 3) {
                return this.retainedSizesStatus;
            }
        }
        if (bl2 && !ProfilerDialogs.displayConfirmationDNSA((String)Bundle.HeapFragmentWalker_ComputeRetainedMsg(), (String)Bundle.HeapFragmentWalker_ComputeRetainedCaption(), null, (String)"HeapFragmentWalker.computeRetainedSizes", (boolean)false)) {
            return this.changeState(1, bl);
        }
        this.changeState(2, bl);
        object = this.heapFragment.getAllClasses();
        if (object.size() > 0) {
            ProgressHandle progressHandle;
            ProgressHandle progressHandle2 = progressHandle = bl2 ? ProgressHandleFactory.createHandle((String)Bundle.HeapFragmentWalker_ComputingRetainedMsg()) : null;
            if (progressHandle != null) {
                progressHandle.start();
            }
            ((JavaClass)object.get(0)).getRetainedSizeByClass();
            if (progressHandle != null) {
                progressHandle.finish();
            }
        }
        return this.changeState(3, bl);
    }

    public final synchronized int getRetainedSizesStatus() {
        return this.retainedSizesStatus;
    }

    public final void addStateListener(StateListener stateListener) {
        if (this.stateListeners == null) {
            this.stateListeners = new ArrayList<StateListener>();
        }
        if (!this.stateListeners.contains(stateListener)) {
            this.stateListeners.add(stateListener);
        }
    }

    public final void removeStateListener(StateListener stateListener) {
        if (this.stateListeners == null || !this.stateListeners.contains(stateListener)) {
            return;
        }
        this.stateListeners.remove(stateListener);
        if (this.stateListeners.size() == 0) {
            this.stateListeners = null;
        }
    }

    private synchronized int changeState(final int n, final boolean bl) {
        this.retainedSizesStatus = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HeapFragmentWalker.this.stateListeners == null) {
                    return;
                }
                StateEvent stateEvent = new StateEvent(n, bl);
                for (StateListener stateListener : HeapFragmentWalker.this.stateListeners) {
                    stateListener.stateChanged(stateEvent);
                }
            }
        });
        return this.retainedSizesStatus;
    }

    public AbstractTopLevelController getActiveController() {
        HeapFragmentWalkerUI heapFragmentWalkerUI = (HeapFragmentWalkerUI)this.getPanel();
        if (heapFragmentWalkerUI == null) {
            return null;
        }
        if (heapFragmentWalkerUI.isSummaryViewActive()) {
            return this.summaryController;
        }
        if (heapFragmentWalkerUI.isClassesViewActive()) {
            return this.classesController;
        }
        if (heapFragmentWalkerUI.isInstancesViewActive()) {
            return this.instancesController;
        }
        if (heapFragmentWalkerUI.isAnalysisViewActive()) {
            return this.analysisController;
        }
        if (heapFragmentWalkerUI.isOQLViewActive()) {
            return this.oqlController;
        }
        return null;
    }

    public OQLController getOQLController() {
        return this.oqlController;
    }

    public AnalysisController getAnalysisController() {
        return this.analysisController;
    }

    public ClassesController getClassesController() {
        return this.classesController;
    }

    public File getHeapDumpFile() {
        return this.heapWalker.getHeapDumpFile();
    }

    public Lookup.Provider getHeapDumpProject() {
        return this.heapWalker.getHeapDumpProject();
    }

    public Heap getHeapFragment() {
        return this.heapFragment;
    }

    public InstancesController getInstancesController() {
        return this.instancesController;
    }

    public boolean isNavigationBackAvailable() {
        return this.navigationHistoryManager.isNavigationBackAvailable();
    }

    public boolean isNavigationForwardAvailable() {
        return this.navigationHistoryManager.isNavigationForwardAvailable();
    }

    public JPanel getPanel() {
        if (this.walkerUI == null) {
            this.walkerUI = new HeapFragmentWalkerUI(this);
        }
        return this.walkerUI;
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    public long getTotalLiveBytes() {
        return this.heapFragment.getSummary().getTotalLiveBytes();
    }

    public long getTotalLiveInstances() {
        return this.heapFragment.getSummary().getTotalLiveInstances();
    }

    public void createNavigationHistoryPoint() {
        HeapFragmentWalkerUI heapFragmentWalkerUI = (HeapFragmentWalkerUI)this.getPanel();
        if (heapFragmentWalkerUI == null) {
            return;
        }
        this.navigationHistoryManager.createNavigationHistoryPoint();
        heapFragmentWalkerUI.updateNavigationActions();
    }

    public void navigateBack() {
        HeapFragmentWalkerUI heapFragmentWalkerUI = (HeapFragmentWalkerUI)this.getPanel();
        if (heapFragmentWalkerUI == null) {
            return;
        }
        this.navigationHistoryManager.navigateBack();
        heapFragmentWalkerUI.updateNavigationActions();
    }

    public void navigateForward() {
        HeapFragmentWalkerUI heapFragmentWalkerUI = (HeapFragmentWalkerUI)this.getPanel();
        if (heapFragmentWalkerUI == null) {
            return;
        }
        this.navigationHistoryManager.navigateForward();
        heapFragmentWalkerUI.updateNavigationActions();
    }

    public void showInstancesForClass(JavaClass javaClass) {
        this.switchToInstancesView();
        this.instancesController.setClass(javaClass);
    }

    public void switchToOQLView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showOQLView();
    }

    public void switchToAnalysisView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showAnalysisView();
    }

    public void switchToClassesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showClassesView();
    }

    public void switchToHistoryOQLView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryOQLView();
    }

    public void switchToHistoryAnalysisView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryAnalysisView();
    }

    public void switchToHistoryClassesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryClassesView();
    }

    public void switchToHistoryInstancesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryInstancesView();
    }

    public void switchToHistorySummaryView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistorySummaryView();
    }

    public void switchToInstancesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showInstancesView();
    }

    public void switchToSummaryView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showSummaryView();
    }

    NavigationHistoryManager.NavigationHistoryCapable getNavigationHistorySource() {
        AbstractTopLevelController abstractTopLevelController = this.getActiveController();
        if (abstractTopLevelController instanceof NavigationHistoryManager.NavigationHistoryCapable) {
            return (NavigationHistoryManager.NavigationHistoryCapable)((Object)abstractTopLevelController);
        }
        return null;
    }

    public static final class StateEvent {
        private int retainedSizesStatus;
        private boolean masterChange;

        StateEvent(int n) {
            this(n, false);
        }

        StateEvent(int n, boolean bl) {
            this.retainedSizesStatus = n;
            this.masterChange = bl;
        }

        public int getRetainedSizesStatus() {
            return this.retainedSizesStatus;
        }

        public boolean isMasterChange() {
            return this.masterChange;
        }
    }

    public static interface StateListener {
        public void stateChanged(StateEvent var1);
    }
}

