/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.threaddump.impl;

import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshot;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.threaddump.ThreadDump;
import com.sun.tools.visualvm.uisupport.HTMLTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ThreadDumpView
extends DataSourceView {
    private static final Logger LOGGER = Logger.getLogger(ThreadDumpView.class.getName());

    public ThreadDumpView(ThreadDump threadDump) {
        this(threadDump, DataSourceDescriptorFactory.getDescriptor((DataSource)threadDump));
    }

    private ThreadDumpView(ThreadDump threadDump, DataSourceDescriptor descriptor) {
        super((DataSource)threadDump, descriptor.getName(), descriptor.getIcon(), 0, ThreadDumpView.isClosableView(threadDump));
    }

    protected DataViewComponent createComponent() {
        ThreadDump threadDump = (ThreadDump)this.getDataSource();
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport(threadDump).getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    private static boolean isClosableView(ThreadDump threadDump) {
        if (!threadDump.isVisible()) {
            return false;
        }
        DataSource owner = threadDump.getOwner();
        if (owner == null) {
            return false;
        }
        while (owner != null && owner != DataSource.ROOT) {
            if (owner instanceof ApplicationSnapshot) {
                return true;
            }
            if (!owner.isVisible()) {
                return false;
            }
            owner = owner.getOwner();
        }
        return owner == DataSource.ROOT;
    }

    private static class MasterViewSupport
    extends JPanel {
        private JLabel progressLabel;
        private JPanel contentsPanel;

        public MasterViewSupport(ThreadDump threadDump) {
            this.initComponents();
            this.loadThreadDump(threadDump.getFile());
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(ThreadDumpView.class, (String)"LBL_Thread_Dump"), null, (JComponent)new ScrollableContainer((JComponent)this));
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.progressLabel = new JLabel(NbBundle.getMessage(ThreadDumpView.class, (String)"MSG_Loading_Thread_Dump"), 0);
            this.contentsPanel = new JPanel(new BorderLayout());
            this.contentsPanel.add((Component)this.progressLabel, "Center");
            this.contentsPanel.setOpaque(false);
            this.add((Component)this.contentsPanel, "Center");
            this.setOpaque(false);
        }

        private static String htmlize(String value) {
            return value.replace("&", "&amp;").replace("<", "&lt;");
        }

        private static String transform(String value) {
            StringBuilder sb = new StringBuilder();
            String[] result = value.split("\\n");
            for (int i = 0; i < result.length; ++i) {
                String line = result[i];
                if (!line.isEmpty() && !Character.isWhitespace(line.charAt(0))) {
                    sb.append("<span style=\"color: #0033CC\">");
                    sb.append(line);
                    sb.append("</span><br>");
                    continue;
                }
                sb.append(line);
                sb.append("<br>");
            }
            return sb.toString();
        }

        private void loadThreadDump(final File file) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(file);
                        byte[] data = new byte[(int)file.length()];
                        try {
                            ((InputStream)is).read(data);
                        }
                        catch (IOException ex) {
                            LOGGER.throwing(ThreadDumpView.class.getName(), "loadThreadDump", ex);
                        }
                        try {
                            HTMLTextArea area = new HTMLTextArea();
                            area.setForeground(new Color(204, 51, 0));
                            area.setText("<pre>" + MasterViewSupport.transform(MasterViewSupport.htmlize(new String(data, "UTF-8"))) + "</pre>");
                            area.setCaretPosition(0);
                            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
                            MasterViewSupport.this.contentsPanel.remove(MasterViewSupport.this.progressLabel);
                            MasterViewSupport.this.contentsPanel.add((Component)area, "Center");
                            MasterViewSupport.this.contentsPanel.revalidate();
                            MasterViewSupport.this.contentsPanel.repaint();
                        }
                        catch (Exception ex) {
                            LOGGER.throwing(ThreadDumpView.class.getName(), "loadThreadDump", ex);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.throwing(ThreadDumpView.class.getName(), "loadThreadDump", ex);
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
        }
    }
}

