/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestStatusToXContentListener;
import org.elasticsearch.search.Scroll;

public class RestSearchScrollAction
extends BaseRestHandler {
    @Inject
    public RestSearchScrollAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll/{scroll_id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll/{scroll_id}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        String scrollId = request.param("scroll_id");
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest();
        searchScrollRequest.scrollId(scrollId);
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null, "scroll")));
        }
        if (RestActions.hasBodyContent(request)) {
            XContentType type = XContentFactory.xContentType(RestActions.getRestContent(request));
            if (type == null) {
                if (scrollId == null) {
                    scrollId = RestActions.getRestContent(request).toUtf8();
                    searchScrollRequest.scrollId(scrollId);
                }
            } else {
                RestSearchScrollAction.buildFromContent(RestActions.getRestContent(request), searchScrollRequest);
            }
        }
        client.searchScroll(searchScrollRequest, new RestStatusToXContentListener<SearchResponse>(channel));
    }

    public static void buildFromContent(BytesReference content, SearchScrollRequest searchScrollRequest) {
        try (XContentParser parser = XContentHelper.createParser(content);){
            XContentParser.Token token;
            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Malforrmed content, must start with an object");
            }
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("scroll_id".equals(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                    searchScrollRequest.scrollId(parser.text());
                    continue;
                }
                if ("scroll".equals(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                    searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue(parser.text(), null, "scroll")));
                    continue;
                }
                throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + (Object)((Object)token) + "] ");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse request body", e);
        }
    }
}

