/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public class TextureState {
    private final int target;
    private final int[] state = new int[]{0, 0, 0, 0, 0, 0};

    public static final int getTextureTargetQueryName(int n) {
        int n2;
        switch (n) {
            case 3553: {
                n2 = 32873;
                break;
            }
            case 34067: {
                n2 = 34068;
                break;
            }
            case 32879: {
                n2 = 32874;
                break;
            }
            case 3552: {
                n2 = 32872;
                break;
            }
            case 35864: {
                n2 = 35868;
                break;
            }
            case 35866: {
                n2 = 35869;
                break;
            }
            case 34037: {
                n2 = 34038;
                break;
            }
            case 35882: {
                n2 = 35884;
                break;
            }
            case 37120: {
                n2 = 37124;
                break;
            }
            case 37122: {
                n2 = 37125;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    private static final int activeTexture(GL gL) {
        int[] nArray = new int[]{0};
        gL.glGetIntegerv(34016, nArray, 0);
        return nArray[0];
    }

    public TextureState(GL gL, int n) throws GLException {
        this(gL, TextureState.activeTexture(gL), n);
    }

    public TextureState(GL gL, int n, int n2) throws GLException {
        this.target = n2;
        this.state[0] = n;
        int n3 = TextureState.getTextureTargetQueryName(n2);
        if (0 == n3) {
            throw new GLException("Unsupported textureTarget " + TextureState.toHexString(n2));
        }
        gL.glGetIntegerv(n3, this.state, 1);
        gL.glGetTexParameteriv(this.target, 10240, this.state, 2);
        gL.glGetTexParameteriv(this.target, 10241, this.state, 3);
        gL.glGetTexParameteriv(this.target, 10242, this.state, 4);
        gL.glGetTexParameteriv(this.target, 10243, this.state, 5);
    }

    public final void restore(GL gL) {
        gL.glActiveTexture(this.state[0]);
        gL.glBindTexture(this.target, this.state[1]);
        gL.glTexParameteri(this.target, 10240, this.state[2]);
        gL.glTexParameteri(this.target, 10241, this.state[3]);
        gL.glTexParameteri(this.target, 10242, this.state[4]);
        gL.glTexParameteri(this.target, 10243, this.state[5]);
    }

    public final int getUnit() {
        return this.state[0];
    }

    public final int getTarget() {
        return this.target;
    }

    public final int getObject() {
        return this.state[1];
    }

    public final int getMagFilter() {
        return this.state[2];
    }

    public final int getMinFilter() {
        return this.state[3];
    }

    public final int getWrapS() {
        return this.state[4];
    }

    public final int getWrapT() {
        return this.state[5];
    }

    public final String toString() {
        return "TextureState[unit " + (this.state[0] - 33984) + ", target " + TextureState.toHexString(this.target) + ": obj " + TextureState.toHexString(this.state[1]) + ", filter[mag " + TextureState.toHexString(this.state[2]) + ", min " + TextureState.toHexString(this.state[3]) + "], " + ": wrap[s " + TextureState.toHexString(this.state[4]) + ", t " + TextureState.toHexString(this.state[5]) + "]]";
    }
}

