/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.VerticalBox;
import org.scilab.forge.jlatexmath.XLeftRightArrowFactory;

public class UnderOverArrowAtom
extends Atom {
    private Atom base;
    private String arrow;
    private boolean over;
    private boolean left = false;
    private boolean dble = false;

    public UnderOverArrowAtom(Atom atom, boolean bl, boolean bl2) {
        this.base = atom;
        this.arrow = bl ? "leftarrow" : "rightarrow";
        this.left = bl;
        this.over = bl2;
    }

    public UnderOverArrowAtom(Atom atom, boolean bl) {
        this.base = atom;
        this.over = bl;
        this.dble = true;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box;
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        Box box2 = this.base != null ? this.base.createBox(teXEnvironment) : new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        float f = new SpaceAtom(3, 1.0f, 0.0f, 0.0f).createBox(teXEnvironment).getWidth();
        if (this.dble) {
            box = XLeftRightArrowFactory.create(teXEnvironment, box2.getWidth());
            f = 4.0f * f;
        } else {
            box = XLeftRightArrowFactory.create(this.left, teXEnvironment, box2.getWidth());
            f = -f;
        }
        VerticalBox verticalBox = new VerticalBox();
        if (this.over) {
            verticalBox.add(box);
            verticalBox.add(new HorizontalBox(box2, box.getWidth(), 2));
            float f2 = verticalBox.getDepth() + verticalBox.getHeight();
            verticalBox.setDepth(box2.getDepth());
            verticalBox.setHeight(f2 - box2.getDepth());
        } else {
            verticalBox.add(new HorizontalBox(box2, box.getWidth(), 2));
            verticalBox.add(new StrutBox(0.0f, f, 0.0f, 0.0f));
            verticalBox.add(box);
            float f3 = verticalBox.getDepth() + verticalBox.getHeight();
            verticalBox.setDepth(f3 - box2.getHeight());
            verticalBox.setHeight(box2.getHeight());
        }
        return verticalBox;
    }
}

